/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.vcs;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsRootEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedOutDir
implements Comparable<CheckedOutDir> {
    private final VcsRoot myRoot;
    private final IncludeRule myRule;

    public CheckedOutDir(VcsRoot root, IncludeRule rule) {
        this.myRoot = root;
        this.myRule = rule;
    }

    public VcsRoot getRoot() {
        return this.myRoot;
    }

    public IncludeRule getRule() {
        return this.myRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckedOutDir that = (CheckedOutDir)o;
        if (this.myRoot.getId() != that.myRoot.getId()) {
            return false;
        }
        return this.myRule.equals(that.myRule);
    }

    public int hashCode() {
        int result = (int)this.myRoot.getId();
        result = 31 * result + this.myRule.hashCode();
        return result;
    }

    public static List<CheckedOutDir> createListFor(List<? extends VcsRootEntry> entries) {
        ArrayList<CheckedOutDir> result = new ArrayList<CheckedOutDir>();
        for (VcsRootEntry vcsRootEntry : entries) {
            for (IncludeRule includeRule : vcsRootEntry.getCheckoutRules().getIncludeRules()) {
                result.add(new CheckedOutDir(vcsRootEntry.getVcsRoot(), includeRule));
            }
        }
        return result;
    }

    @Override
    public int compareTo(CheckedOutDir o) {
        return this.getRule().getTo().compareTo(o.getRule().getTo());
    }

    public String toString() {
        return "CheckedOutDir{myRoot=" + this.myRoot + ", myRule=" + this.myRule + '}';
    }
}

