/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Condition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsUtil {
    public static final Filter ACCEPT_ALL = new Filter(){

        public boolean accept(@NotNull Object data) {
            if (data == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil$1.accept must not be null");
            }
            return true;
        }
    };
    public static final Converter SAME = new Converter(){

        public Object createFrom(@NotNull Object source) {
            if (source == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil$2.createFrom must not be null");
            }
            return source;
        }
    };

    @NotNull
    public static <T> Filter<T> acceptAllFilter() {
        Filter filter = ACCEPT_ALL;
        if (filter == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.acceptAllFilter must not return null");
        }
        return filter;
    }

    private CollectionsUtil() {
    }

    public static <ResultType, SourceType> List<ResultType> filterAndConvertCollection(Collection<? extends SourceType> source, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (converter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterAndConvertCollection must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterAndConvertCollection must not be null");
        }
        Collection<? extends SourceType> iterable = source;
        return CollectionsUtil.filterAndConvertCollection(iterable, converter, filter);
    }

    public static <ResultType, SourceType> List<ResultType> filterAndConvertCollection(Iterable<? extends SourceType> source, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (converter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterAndConvertCollection must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterAndConvertCollection must not be null");
        }
        ArrayList result = CollectionsUtil.filterAndConvertCollection(source, new ArrayList(), converter, filter);
        return result == null ? null : Collections.unmodifiableList(result);
    }

    public static <ResultType, ResultCollection extends Collection<ResultType>, SourceType> ResultCollection filterAndConvertCollection(Iterable<? extends SourceType> source, @NotNull ResultCollection collection, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterAndConvertCollection must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterAndConvertCollection must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterAndConvertCollection must not be null");
        }
        if (source == null) {
            return null;
        }
        if (source != null) {
            for (SourceType o : source) {
                if (!filter.accept(o)) continue;
                Object newO = null;
                if (o != null) {
                    newO = converter.createFrom(o);
                }
                collection.add(newO);
            }
        }
        return collection;
    }

    public static <T> Collection<T> join(Collection<T> ... a) {
        int size = 0;
        for (Collection<T> collection : a) {
            size += collection.size();
        }
        ArrayList<T> union = new ArrayList<T>(size);
        for (Collection<T> collection : a) {
            union.addAll(collection);
        }
        return union;
    }

    public static <T> Collection<T> join(@NotNull Collection<T> a, @NotNull Collection<T> b) {
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.join must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.join must not be null");
        }
        ArrayList<T> list = new ArrayList<T>(a.size() + b.size());
        list.addAll(a);
        list.addAll(b);
        return list;
    }

    public static <T> Collection<T> join(@NotNull Collection<T> a, @NotNull Collection<T> b, @NotNull Collection<T> c) {
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.join must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.join must not be null");
        }
        if (c == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.join must not be null");
        }
        ArrayList<T> list = new ArrayList<T>(a.size() + b.size() + c.size());
        list.addAll(a);
        list.addAll(b);
        list.addAll(c);
        return list;
    }

    public static <SourceType> List<SourceType> filterCollection(Collection<? extends SourceType> source, Filter<SourceType> filter) {
        Collection<? extends SourceType> iterable = source;
        return CollectionsUtil.filterCollection(iterable, filter);
    }

    public static <SourceType> List<SourceType> filterCollection(Iterable<? extends SourceType> source, Filter<SourceType> filter) {
        return CollectionsUtil.filterAndConvertCollection(source, SAME, filter);
    }

    public static <ResultType, SourceType> List<ResultType> convertCollection(Collection<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        return CollectionsUtil.filterAndConvertCollection(source, converter, CollectionsUtil.acceptAllFilter());
    }

    public static <ResultType, SourceType> List<ResultType> convertCollection(Iterable<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        return CollectionsUtil.filterAndConvertCollection(source, converter, CollectionsUtil.acceptAllFilter());
    }

    public static <ResultType, SourceType> Set<ResultType> convertSet(Collection<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        Collection<? extends SourceType> iterable = source;
        return CollectionsUtil.convertSet(iterable, converter);
    }

    public static <ResultType, SourceType> Set<ResultType> convertSet(Iterable<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        HashSet result = CollectionsUtil.filterAndConvertCollection(source, new HashSet(), converter, CollectionsUtil.acceptAllFilter());
        return result != null ? Collections.unmodifiableSet(result) : null;
    }

    public static <SourceType> List<SourceType> collectUniqueObjectList(List<SourceType> list) {
        return new ArrayList<SourceType>(new LinkedHashSet<SourceType>(list));
    }

    public static <T> T findFirst(Iterable<T> list, Filter<T> filter) {
        for (T element : list) {
            if (!filter.accept(element)) continue;
            return element;
        }
        return null;
    }

    public static <T extends Comparable<T>> void insertWithSorting(@NotNull T o, @NotNull List<T> list) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.insertWithSorting must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.insertWithSorting must not be null");
        }
        for (int i = 0; i < list.size(); ++i) {
            if (o.compareTo(list.get(i)) >= 0) continue;
            list.add(i, o);
            return;
        }
        list.add(o);
    }

    public static <T> void insertWithSorting(@NotNull T o, @NotNull List<T> list, @NotNull Comparator<T> comp) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.insertWithSorting must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.insertWithSorting must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.insertWithSorting must not be null");
        }
        for (int i = 0; i < list.size(); ++i) {
            if (comp.compare(o, list.get(i)) >= 0) continue;
            list.add(i, o);
            return;
        }
        list.add(o);
    }

    @NotNull
    public static String to_s(@NotNull Collection c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.to_s must not be null");
        }
        StringBuilder sb = new StringBuilder();
        if (c.size() > 0) {
            for (Object o : c) {
                sb.append("\r\n");
                sb.append(o.toString());
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.to_s must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<List<T>> split(@NotNull List<T> toSplit, int numParts) {
        ArrayList<List<T>> arrayList;
        if (toSplit == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.split must not be null");
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (toSplit.size() <= numParts) {
            result.add(toSplit);
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.split must not return null");
            return arrayList;
        }
        int partSize = (int)Math.round(1.0 * (double)toSplit.size() / (double)numParts);
        for (int i = 0; i < numParts; ++i) {
            int fromIdx = i * partSize;
            int toIdx = i + 1 == numParts ? toSplit.size() : Math.min(fromIdx + partSize, toSplit.size());
            List<T> subList = toSplit.subList(fromIdx, toIdx);
            result.add(subList);
        }
        arrayList = result;
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.split must not return null");
    }

    public static void retainMatched(@Nullable Collection<String> stringCollection, @NotNull Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.retainMatched must not be null");
        }
        if (stringCollection == null || stringCollection.isEmpty()) {
            return;
        }
        Iterator<String> it = stringCollection.iterator();
        while (it.hasNext()) {
            if (pattern.matcher(it.next()).matches()) continue;
            it.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Set<T> minus(Collection<T> minuend, Set<T> subtrahend) {
        Set set;
        if (minuend == null || minuend.isEmpty()) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.minus must not return null");
            return set;
        }
        HashSet remainder = new HashSet(minuend.size());
        for (T item : minuend) {
            if (subtrahend.contains(item)) continue;
            remainder.add(item);
        }
        set = remainder;
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.minus must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Set<T> intersect(@Nullable Collection<T> set1, @Nullable Collection<T> set2) {
        Set set;
        if (set1 == null || set1.isEmpty() || set2 == null || set2.isEmpty()) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.intersect must not return null");
            return set;
        }
        HashSet result = new HashSet(Math.min(set1.size(), set2.size()));
        for (T item : set1) {
            if (!set2.contains(item)) continue;
            result.add(item);
        }
        set = result;
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.intersect must not return null");
    }

    @NotNull
    public static <T, Coll extends Iterable<T>> Coll removeNulls(@NotNull Coll collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.removeNulls must not be null");
        }
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        Coll Coll = collection;
        if (Coll == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.removeNulls must not return null");
        }
        return Coll;
    }

    @NotNull
    public static <T> List<T> filterNulls(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterNulls must not be null");
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (T element : collection) {
            if (element == null) continue;
            result.add(element);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.filterNulls must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <Result, Source> List<Result> convertAndFilterNulls(@NotNull Iterable<Source> source, @NotNull Converter<Result, Source> converter) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.convertAndFilterNulls must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.convertAndFilterNulls must not be null");
        }
        List<Result> list = CollectionsUtil.filterNulls(CollectionsUtil.convertCollection(source, converter));
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.convertAndFilterNulls must not return null");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NotNull
    public static <T> Collection<T> unite(Collection<? extends T> ... col) {
        void var5_8;
        if (col == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.unite must not be null");
        }
        int size = 0;
        for (Collection<T> collection : col) {
            size += collection.size();
        }
        ArrayList<? extends T> union = new ArrayList<T>(size);
        Collection<? extends T>[] arr$ = col;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_8 < len$) {
            Collection<? extends T> collection = arr$[var5_8];
            union.addAll(collection);
            ++var5_8;
        }
        ArrayList<? extends T> arrayList = union;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.unite must not return null");
        }
        return arrayList;
    }

    public static <T> List<T> applyOrder(@NotNull String[] sortedIds, @NotNull List<T> allElems, @NotNull Map<String, T> idToElementMap) {
        if (sortedIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.applyOrder must not be null");
        }
        if (allElems == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.applyOrder must not be null");
        }
        if (idToElementMap == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.applyOrder must not be null");
        }
        ArrayList<T> newOrder = new ArrayList<T>();
        for (String id : sortedIds) {
            T elem = idToElementMap.get(id);
            if (elem == null) continue;
            newOrder.add(elem);
        }
        int newOrderIdx = 0;
        ArrayList<T> result = new ArrayList<T>(allElems);
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (newOrder.indexOf(item) == -1) continue;
            result.set(i, newOrder.get(newOrderIdx++));
        }
        return result;
    }

    @NotNull
    public static <T> Map<T, T> asMap(T ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.asMap must not be null");
        }
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The number of arguments must be even");
        }
        LinkedHashMap<T, T> result = new LinkedHashMap<T, T>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            result.put(args[i], args[i + 1]);
        }
        LinkedHashMap<T, T> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.asMap must not return null");
        }
        return linkedHashMap;
    }

    @NotNull
    public static <T> Set<T> setOf(T ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.setOf must not be null");
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(args));
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.setOf must not return null");
        }
        return hashSet;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.removeDuplicates must not be null");
        }
        HashSet<T> set = new HashSet<T>(collection);
        collection.clear();
        collection.addAll(set);
    }

    public static <T> int binarySearch(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.binarySearch must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.binarySearch must not be null");
        }
        int falseIndex = 0;
        int trueIndex = list.size();
        while (falseIndex < trueIndex) {
            int midIndex = falseIndex + trueIndex >> 1;
            if (condition.value(list.get(midIndex))) {
                trueIndex = midIndex;
                continue;
            }
            falseIndex = midIndex + 1;
        }
        return trueIndex;
    }

    @NotNull
    public static <T> Iterator<T> toTypedIteartor(final @NotNull Class<T> clazz, final @NotNull Iterator data) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.toTypedIteartor must not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.toTypedIteartor must not be null");
        }
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return data.hasNext();
            }

            @Override
            public T next() {
                return clazz.cast(data.next());
            }

            @Override
            public void remove() {
                data.remove();
            }
        };
        if (iterator == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.toTypedIteartor must not return null");
        }
        return iterator;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMapByKeys(@NotNull Map<K, V> map, @NotNull Filter<K> filter) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterMapByKeys must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterMapByKeys must not be null");
        }
        Map<K, V> map2 = CollectionsUtil.filterMap(map, filter, CollectionsUtil.acceptAllFilter());
        if (map2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.filterMapByKeys must not return null");
        }
        return map2;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMapByValues(@NotNull Map<K, V> map, @NotNull Filter<V> filter) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterMapByValues must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterMapByValues must not be null");
        }
        Map<K, V> map2 = CollectionsUtil.filterMap(map, CollectionsUtil.acceptAllFilter(), filter);
        if (map2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.filterMapByValues must not return null");
        }
        return map2;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMap(@NotNull Map<K, V> map, @NotNull Filter<K> keyFilter, @NotNull Filter<V> valueFilter) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterMap must not be null");
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterMap must not be null");
        }
        if (valueFilter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.filterMap must not be null");
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> kv : map.entrySet()) {
            if (!keyFilter.accept(kv.getKey()) || !valueFilter.accept(kv.getValue())) continue;
            result.put(kv.getKey(), kv.getValue());
        }
        LinkedHashMap<K, V> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/CollectionsUtil.filterMap must not return null");
        }
        return linkedHashMap;
    }

    public static <K, V> int count(@NotNull Map<K, V> map, @NotNull Filter<K> keyFilter, @NotNull Filter<V> valueFilter) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.count must not be null");
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.count must not be null");
        }
        if (valueFilter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/CollectionsUtil.count must not be null");
        }
        int count = 0;
        for (Map.Entry<K, V> kv : map.entrySet()) {
            if (!keyFilter.accept(kv.getKey()) || !valueFilter.accept(kv.getValue())) continue;
            ++count;
        }
        return count;
    }
}

