/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.EventListenerAdapter;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.positioning.PositionAware;
import jetbrains.buildServer.util.positioning.PositionAwareSortedCollection;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import jetbrains.buildServer.util.positioning.PositionConstraintAware;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcherHandlers<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance((String)EventDispatcher.class.getName());
    private final Class<T> myListenerClass;
    private final Method[] myListenerMethods;
    private final PositionAwareSortedCollection<T> myListeners = new PositionAwareSortedCollection();
    private final Map<Class<? extends EventListener>, BitSet> myTypeToMethodsCache = new HashMap<Class<? extends EventListener>, BitSet>();

    public EventDispatcherHandlers(Class<T> listenerClass) {
        this.myListenerClass = listenerClass;
        this.myListenerMethods = listenerClass.getMethods();
    }

    public void addListener(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/EventDispatcherHandlers.addListener must not be null");
        }
        this.myListeners.add(listener, listener instanceof PositionAware ? ((PositionAware)listener).getOrderId() : listener.getClass().getName(), listener instanceof PositionConstraintAware ? ((PositionConstraintAware)listener).getConstraint() : PositionConstraint.UNDEFINED);
        this.updateMethodsCache(listener.getClass());
    }

    private void updateMethodsCache(@NotNull Class<? extends EventListener> actualClass) {
        if (actualClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/EventDispatcherHandlers.updateMethodsCache must not be null");
        }
        if (this.myTypeToMethodsCache.containsKey(actualClass)) {
            return;
        }
        BitSet set = this.createBitSet();
        int myListenerMethodsLength = this.myListenerMethods.length;
        for (int i = 0; i < myListenerMethodsLength; ++i) {
            Method method = this.myListenerMethods[i];
            if (!this.isMethodImplemented(actualClass, method)) continue;
            set.set(i);
        }
        if (set.isEmpty()) {
            LOG.warn("Listener class " + actualClass + " does not contain any non-empty event listening method " + "implementations. Check there are some overridden methods or this class is not annotated " + "with " + EventListenerAdapter.class + ".");
        }
        this.myTypeToMethodsCache.put(actualClass, set);
    }

    @NotNull
    private BitSet createBitSet() {
        BitSet bitSet = new BitSet(this.myListenerMethods.length);
        if (bitSet == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/EventDispatcherHandlers.createBitSet must not return null");
        }
        return bitSet;
    }

    public void removeListener(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/EventDispatcherHandlers.removeListener must not be null");
        }
        this.myListeners.removeWhere(new Filter<T>((EventListener)listener){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            @Override
            public boolean accept(@NotNull T data) {
                if (data == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/EventDispatcherHandlers$1.accept must not be null");
                }
                return this.val$listener == data;
            }
        });
    }

    @NotNull
    public List<T> getListeners() {
        List<T> list = this.myListeners.getSorted();
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/EventDispatcherHandlers.getListeners must not return null");
        }
        return list;
    }

    private T[] createArray(int size) {
        return (EventListener[])Array.newInstance(this.myListenerClass, size);
    }

    @NotNull
    public Map<Method, T[]> serialize() {
        EventListener[] sorted = this.myListeners.getSorted().toArray(this.createArray(this.myListeners.size()));
        HashMap<Method, T[]> map = new HashMap<Method, T[]>(this.myListenerMethods.length);
        int myListenerMethodsLength = this.myListenerMethods.length;
        for (int i = 0; i < myListenerMethodsLength; ++i) {
            Method method = this.myListenerMethods[i];
            ArrayList<EventListener> data = new ArrayList<EventListener>(sorted.length);
            for (EventListener t : sorted) {
                if (!this.myTypeToMethodsCache.get(t.getClass()).get(i)) continue;
                data.add(t);
            }
            map.put(method, data.toArray(this.createArray(data.size())));
        }
        HashMap<Method, T[]> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/EventDispatcherHandlers.serialize must not return null");
        }
        return hashMap;
    }

    private boolean isMethodImplemented(Class<? extends EventListener> actualClass, Method method) {
        Method p = this.findSameMethod(actualClass, method);
        return !this.isEventAdapter(p.getDeclaringClass());
    }

    private boolean isEventAdapter(Class<?> declaringClass) {
        return declaringClass.isAnnotationPresent(EventListenerAdapter.class);
    }

    private Method findSameMethod(Class<? extends EventListener> actualClass, Method method) {
        try {
            return actualClass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Object " + actualClass + " does not contain implementation of method " + method + " while implements " + this.myListenerClass);
        }
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    public void clear() {
        this.myListeners.clear();
    }
}

