/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashSet;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionUtil {
    public static Runnable catchAll(final @NotNull String actionName, final @NotNull Runnable action) {
        if (actionName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.catchAll must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.catchAll must not be null");
        }
        return new Runnable(){

            public void run() {
                try {
                    action.run();
                }
                catch (Throwable t) {
                    try {
                        Logger.getLogger(action.getClass()).warn((Object)("Failed to execute " + actionName + ". " + t.getMessage()), t);
                    }
                    catch (Throwable tt) {
                        try {
                            t.printStackTrace();
                        }
                        catch (Throwable ttt) {
                            // empty catch block
                        }
                        try {
                            tt.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }

    public static void rethrowAsRuntimeException(@NotNull Throwable t) throws RuntimeException {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.rethrowAsRuntimeException must not be null");
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static void dumpStacktrace(@NotNull StringBuilder stringBuffer, @NotNull Throwable exception) {
        StackTraceElement[] trace;
        if (stringBuffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.dumpStacktrace must not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.dumpStacktrace must not be null");
        }
        String exceptionStr = exception.toString();
        stringBuffer.append(exceptionStr);
        if (!exceptionStr.endsWith("\n")) {
            stringBuffer.append('\n');
        }
        for (StackTraceElement entry : trace = exception.getStackTrace()) {
            stringBuffer.append("\tat ").append(entry.toString()).append('\n');
        }
        Throwable caused = exception.getCause();
        if (caused != null && caused != exception) {
            stringBuffer.append("caused by: ");
            ExceptionUtil.dumpStacktrace(stringBuffer, caused);
        }
    }

    public static void log(@NotNull Logger log, @NotNull String prefixMessage, @NotNull Throwable e) {
        if (log == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.log must not be null");
        }
        if (prefixMessage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.log must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.log must not be null");
        }
        log.warn((Object)ExceptionUtil.createWarningMessage(prefixMessage, e));
        log.debug((Object)e.getMessage(), e);
    }

    public static void log(@NotNull com.intellij.openapi.diagnostic.Logger log, @NotNull String prefixMessage, @NotNull Throwable e) {
        if (log == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.log must not be null");
        }
        if (prefixMessage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.log must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.log must not be null");
        }
        log.warn(ExceptionUtil.createWarningMessage(prefixMessage, e));
        log.debug(e.getMessage(), e);
    }

    @NotNull
    private static String createWarningMessage(@NotNull String prefixMessage, @NotNull Throwable e) {
        if (prefixMessage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.createWarningMessage must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.createWarningMessage must not be null");
        }
        String string = prefixMessage + ": " + e.getClass().getName() + ": " + e.getMessage();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ExceptionUtil.createWarningMessage must not return null");
        }
        return string;
    }

    @Nullable
    public static <T extends Throwable> T getCause(@Nullable Throwable e, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.getCause must not be null");
        }
        if (e == null) {
            return null;
        }
        HashSet<Throwable> visitedCauses = new HashSet<Throwable>();
        Throwable cause = e;
        do {
            if (clazz.isInstance(cause)) {
                return (T)cause;
            }
            visitedCauses.add(cause);
        } while ((cause = cause.getCause()) != null && !visitedCauses.contains(cause));
        return null;
    }

    @NotNull
    public static String getDisplayMessage(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.getDisplayMessage must not be null");
        }
        String string = String.valueOf(ExceptionUtil.getMostInternalCause(t).getMessage()).trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ExceptionUtil.getDisplayMessage must not return null");
        }
        return string;
    }

    @NotNull
    private static Throwable getMostInternalCause(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ExceptionUtil.getMostInternalCause must not be null");
        }
        HashSet<Throwable> visitedCauses = new HashSet<Throwable>();
        visitedCauses.add(e);
        Throwable cause = e;
        while (true) {
            Throwable causeCause;
            if ((causeCause = cause.getCause()) == null || visitedCauses.contains(causeCause)) {
                Throwable throwable = cause;
                if (throwable == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ExceptionUtil.getMostInternalCause must not return null");
                }
                return throwable;
            }
            visitedCauses.add(causeCause);
            cause = causeCause;
        }
    }
}

