/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.Predicate;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.XmlUtil;
import org.apache.commons.io.FileSystemUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil
extends com.intellij.openapi.util.io.FileUtil {
    private static final Logger LOG;
    private static final String FIX_DIRECTORY_NAME_PATTERN = "[^A-Za-z0-9_ &#.@$%\\[\\]\\(\\){}\\-+=]";
    private static final String BAD_DIRECTORY_NAME_PATTERN = ".*[^A-Za-z0-9_ &#.@$%\\[\\]\\(\\){}\\-+=].*";
    private static final Comparator<File> FILE_COMPARATOR;
    private static final File[] ourEmptyFilesArray;
    private static final Method IO_FILE_SET_EXECUTABLE_METHOD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> readFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readFile must not be null");
        }
        FileInputStream is = new FileInputStream(file);
        String text = StreamUtil.readText((InputStream)is);
        List<String> list = Arrays.asList(text.split("\\r?\\n"));
        List<String> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.readFile must not return null");
        }
        return list2;
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readText must not be null");
        }
        FileInputStream is = new FileInputStream(file);
        try {
            String string = StreamUtil.readText((InputStream)is);
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(@NotNull File file, @NotNull String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readText must not be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readText must not be null");
        }
        FileInputStream is = new FileInputStream(file);
        try {
            String string = StreamUtil.readText((InputStream)is, (String)encoding);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static void writeFile(@NotNull File file, @NotNull String text) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.writeFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.writeFile must not be null");
        }
        try {
            FileUtil.writeFileAndReportErrors(file, text);
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileAndReportErrors(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.writeFileAndReportErrors must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.writeFileAndReportErrors must not be null");
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(text);
        }
        catch (Throwable throwable) {
            FileUtil.close(fileWriter);
            throw throwable;
        }
        FileUtil.close(fileWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(@NotNull File file, @NotNull String text, @NotNull String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.writeFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.writeFile must not be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.writeFile must not be null");
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            writer.write(text);
        }
        catch (Throwable throwable) {
            FileUtil.close(writer);
            throw throwable;
        }
        FileUtil.close(writer);
    }

    public static void readXmlFile(@NotNull File file, @NotNull Processor p) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readXmlFile must not be null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readXmlFile must not be null");
        }
        if (file.exists()) {
            try {
                FileUtil.getProcessedDocument(file, p);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    private static Document getProcessedDocument(@NotNull File file, @NotNull Processor p) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getProcessedDocument must not be null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getProcessedDocument must not be null");
        }
        Document document = FileUtil.parseDocument(file).getDocument();
        p.process(document.getRootElement());
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getProcessedDocument must not return null");
        }
        return document2;
    }

    @NotNull
    private static SAXBuilder getBuilder(boolean validate) {
        SAXBuilder builder = new SAXBuilder(validate);
        builder.setFeature("http://xml.org/sax/features/namespaces", true);
        builder.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        builder.setEntityResolver((EntityResolver)new DefaultHandler(){

            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                String dtdFileName = new File(systemId).getName();
                InputStream dtdStream = this.getClass().getClassLoader().getResourceAsStream(dtdFileName);
                if (dtdStream != null) {
                    return new InputSource(dtdStream);
                }
                return super.resolveEntity(publicId, systemId);
            }
        });
        SAXBuilder sAXBuilder = builder;
        if (sAXBuilder == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getBuilder must not return null");
        }
        return sAXBuilder;
    }

    public static Element parseDocument(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.parseDocument must not be null");
        }
        return FileUtil.parseDocument(file, false);
    }

    public static Element parseDocument(@NotNull File file, boolean validate) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.parseDocument must not be null");
        }
        return FileUtil.getBuilder(validate).build(file).getRootElement();
    }

    public static Element parseDocument(@NotNull InputStream input, boolean validate) throws JDOMException, IOException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.parseDocument must not be null");
        }
        return FileUtil.getBuilder(validate).build(input).getRootElement();
    }

    public static void processXmlFile(@NotNull File file, @NotNull Processor p) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.processXmlFile must not be null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.processXmlFile must not be null");
        }
        if (file.exists()) {
            try {
                FileUtil.saveDocument(FileUtil.getProcessedDocument(file, p), file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocument(@NotNull Document document, @NotNull File file) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.saveDocument must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.saveDocument must not be null");
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            XmlUtil.saveDocument(document, fos);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getFilesSignature(@NotNull Collection<File> _files) {
        if (_files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getFilesSignature must not be null");
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(_files);
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int hash = 0;
        byte[] bytes = new byte[8192];
        for (File file : files) {
            if (file.isDirectory()) continue;
            try {
                hash = 31 * hash + 1;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                try {
                    int count;
                    do {
                        count = ((InputStream)is).read(bytes, 0, bytes.length);
                        for (int i = 0; i < count; ++i) {
                            hash = 31 * hash + bytes[i];
                        }
                    } while (count >= 0);
                }
                finally {
                    FileUtil.close(is);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(file.getAbsolutePath() + ": " + hash);
        }
        String s = Integer.toHexString(hash);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature of the files  : " + s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getFilesSignature must not return null");
        }
        return string;
    }

    @NotNull
    public static File createTempDirectory(String prefix, String suffix, File in) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix, in);
        tempFile.delete();
        tempFile.mkdir();
        File file = tempFile;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.createTempDirectory must not return null");
        }
        return file;
    }

    @NotNull
    public static File getFileInSameDir(@NotNull File origFile, String neededFileName) {
        if (origFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getFileInSameDir must not be null");
        }
        File parent = origFile.getParentFile();
        File file = parent != null ? new File(parent, neededFileName) : new File(neededFileName);
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getFileInSameDir must not return null");
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static File resolvePath(@NotNull File baseDir, @NotNull String path) {
        File file;
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.resolvePath must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.resolvePath must not be null");
        }
        File pathFile = new File(path);
        if (pathFile.isAbsolute()) {
            file = pathFile;
            if (file == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.resolvePath must not return null");
            return file;
        }
        File rawFile = new File(baseDir, path);
        if (baseDir.getPath().startsWith("\\\\")) {
            file = rawFile;
            if (file == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.resolvePath must not return null");
            return file;
        }
        file = new File(rawFile.toURI().normalize().getPath());
        if (file != null) return file;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.resolvePath must not return null");
    }

    public static void copyResource(@NotNull String resourceName, @NotNull File outputFile) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResource must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResource must not be null");
        }
        FileUtil.copyResource(FileUtil.class, resourceName, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResource must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResource must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResource must not be null");
        }
        InputStream asStream = null;
        FileOutputStream outputStream = null;
        try {
            asStream = clazz.getResourceAsStream(resourceName);
            if (asStream != null) {
                outputStream = new FileOutputStream(outputFile);
                StreamUtil.copyStreamContent((InputStream)asStream, (OutputStream)outputStream);
            } else {
                LOG.warn("Failed to copy resource " + resourceName + " from class " + clazz.getName() + ", resource not found");
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to copy resource " + resourceName + " from class " + clazz.getName() + ", due to the error: " + t.getMessage());
        }
        finally {
            if (asStream != null) {
                try {
                    asStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    public static void copyResourceIfNotExists(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResourceIfNotExists must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResourceIfNotExists must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResourceIfNotExists must not be null");
        }
        if (!outputFile.exists()) {
            FileUtil.copyResource(clazz, resourceName, outputFile);
        }
    }

    public static void copyResourceWithDist(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResourceWithDist must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResourceWithDist must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyResourceWithDist must not be null");
        }
        try {
            File distFile = new File(outputFile.getParent(), outputFile.getName() + ".dist");
            if (!outputFile.exists() || !distFile.exists() || FileUtil.readText(outputFile).equals(FileUtil.readText(distFile))) {
                FileUtil.copyResource(clazz, resourceName, outputFile);
            }
            FileUtil.copyResource(clazz, resourceName, distFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readResourceAsString(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull Charset charset) throws IOException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readResourceAsString must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readResourceAsString must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.readResourceAsString must not be null");
        }
        InputStream rcStream = clazz.getResourceAsStream(resourceName);
        if (rcStream == null) {
            return null;
        }
        try {
            String string;
            InputStreamReader rdr = new InputStreamReader(rcStream, charset);
            try {
                string = StreamUtil.readTextFrom((Reader)rdr);
            }
            catch (Throwable throwable) {
                ((Reader)rdr).close();
                throw throwable;
            }
            ((Reader)rdr).close();
            return string;
        }
        finally {
            rcStream.close();
        }
    }

    public static void copyStreams(InputStream is, OutputStream os) throws IOException {
        TCStreamUtil.writeBinary(is, os);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFilePart(@NotNull File sourceFile, long offset, long length, @NotNull OutputStream outputStream) throws IOException {
        void destination;
        if (sourceFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyFilePart must not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyFilePart must not be null");
        }
        FileUtil.copyStreamRangeAndClose(new BufferedInputStream(new FileInputStream(sourceFile)), offset, length, (OutputStream)destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void copyStreamRangeAndClose(@NotNull InputStream source, long offset, long length, @NotNull OutputStream outputStream) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyStreamRangeAndClose must not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copyStreamRangeAndClose must not be null");
        }
        try {
            void destination;
            TCStreamUtil.skip(source, offset);
            TCStreamUtil.writeBinary(source, length, (OutputStream)destination);
        }
        finally {
            FileUtil.close(source);
        }
    }

    public static void close(@Nullable Closeable e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAll(Closeable ... toClose) {
        if (toClose == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.closeAll must not be null");
        }
        for (Closeable e : toClose) {
            if (e == null) continue;
            try {
                e.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<File> getSubDirectories(@NotNull File root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getSubDirectories must not be null");
        }
        File[] files = root.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        List<Object> list = files == null ? Collections.emptyList() : Arrays.asList(files);
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getSubDirectories must not return null");
        }
        return list;
    }

    @NotNull
    public static File createDir(@NotNull File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.createDir must not be null");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
        }
        File file = dir;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.createDir must not return null");
        }
        return file;
    }

    public static File createEmptyDir(@NotNull File dir) throws IOException {
        File[] files;
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.createEmptyDir must not be null");
        }
        if (dir.exists() && (files = dir.listFiles()) != null && files.length > 0) {
            FileUtil.delete((File)dir);
        }
        FileUtil.createDir(dir);
        return dir;
    }

    public static long getTotalDirectorySize(@Nullable File dir) {
        if (dir == null) {
            return 0L;
        }
        long size = 0L;
        for (File file : dir.listFiles()) {
            if (!file.isFile()) continue;
            size += file.length();
        }
        return size;
    }

    public static void deleteIfEmpty(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.deleteIfEmpty must not be null");
        }
        if (FileUtil.isEmptyDir(dir)) {
            FileUtil.delete((File)dir);
        }
    }

    public static boolean isEmptyDir(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.isEmptyDir must not be null");
        }
        File[] files = dir.listFiles();
        if (files == null && dir.isDirectory()) {
            return false;
        }
        return files == null || files.length == 0;
    }

    @NotNull
    public static String fixDirectoryName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.fixDirectoryName must not be null");
        }
        String string = name.replaceAll(FIX_DIRECTORY_NAME_PATTERN, "_");
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.fixDirectoryName must not return null");
        }
        return string;
    }

    public static boolean isBadDirectoryName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.isBadDirectoryName must not be null");
        }
        return name.matches(BAD_DIRECTORY_NAME_PATTERN);
    }

    @NotNull
    public static String normalizeSeparator(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.normalizeSeparator must not be null");
        }
        StringBuilder result = new StringBuilder(filePath.length());
        for (int i = 0; i < filePath.length(); ++i) {
            char c = filePath.charAt(i);
            result.append(c == '/' || c == '\\' ? File.separatorChar : c);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.normalizeSeparator must not return null");
        }
        return string;
    }

    @NotNull
    public static String normalizeRelativePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.normalizeRelativePath must not be null");
        }
        String string = new PathNormalizer(path).invoke();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.normalizeRelativePath must not return null");
        }
        return string;
    }

    public static void sortFiles(@NotNull File[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.sortFiles must not be null");
        }
        Arrays.sort(files, FILE_COMPARATOR);
    }

    @NotNull
    public static String getCommonParent(@NotNull String firstUrl, @NotNull String secondUrl) {
        char c2;
        char c1;
        int i;
        if (firstUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getCommonParent must not be null");
        }
        if (secondUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getCommonParent must not be null");
        }
        StringBuffer result = new StringBuffer();
        StringBuffer nextPathElem = new StringBuffer();
        boolean addSeparator = false;
        for (i = 0; i < firstUrl.length() && i < secondUrl.length() && (c1 = firstUrl.charAt(i)) == (c2 = secondUrl.charAt(i)); ++i) {
            if (FileUtil.isFileSeparator(c1) || FileUtil.isFileSeparator(c2)) {
                if (addSeparator) {
                    result.append("/");
                }
                if (nextPathElem.length() > 0) {
                    result.append(nextPathElem.toString());
                    nextPathElem = new StringBuffer();
                    addSeparator = true;
                    continue;
                }
                if (addSeparator) {
                    result.append("/");
                    addSeparator = false;
                    continue;
                }
                addSeparator = true;
                continue;
            }
            nextPathElem.append(c1);
        }
        if ((i == firstUrl.length() || i == secondUrl.length()) && nextPathElem.length() > 0) {
            if (result.length() > 0) {
                result.append("/");
            }
            result.append(nextPathElem.toString());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getCommonParent must not return null");
        }
        return string;
    }

    public static boolean isFileSeparator(char c1) {
        return c1 == '\\' || c1 == '/';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static File getCanonicalFile(@NotNull File file) {
        File file2;
        File file3;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getCanonicalFile must not be null");
        }
        try {
            file3 = file.getCanonicalFile();
        }
        catch (IOException e) {
            file2 = file.getAbsoluteFile();
            if (file2 == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getCanonicalFile must not return null");
            return file2;
        }
        file2 = file3;
        if (file3 == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getCanonicalFile must not return null");
        return file2;
    }

    public static void checkTmpDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpDir.isDirectory() && !tmpDir.mkdirs()) {
            throw new IllegalStateException("\n\n\nUnable to access temp directory " + tmpDir.getAbsolutePath() + "\n\n\n");
        }
    }

    @Nullable
    public static File findFile(@NotNull FileFilter filter, File ... directories) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.findFile must not be null");
        }
        if (directories == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.findFile must not be null");
        }
        Collection<File> found = FileUtil.doFindFiles(filter, directories, true);
        if (found.size() == 0) {
            return null;
        }
        return found.iterator().next();
    }

    @NotNull
    public static Collection<File> findFiles(@NotNull FileFilter filter, File ... directories) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.findFiles must not be null");
        }
        if (directories == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.findFiles must not be null");
        }
        Collection<File> collection = FileUtil.doFindFiles(filter, directories, false);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.findFiles must not return null");
        }
        return collection;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    private static Collection<File> doFindFiles(@NotNull FileFilter filter, @NotNull File[] directories, boolean stopOnFirstMatch) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.doFindFiles must not be null");
        }
        if (directories == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.doFindFiles must not be null");
        }
        found = new HashSet<File>();
        processed = new HashSet<File>();
        directoriesToSearch = new LinkedList<File>();
        for (File dir : directories) {
            absDir = dir.getAbsoluteFile();
            if (!processed.add(absDir)) continue;
            directoriesToSearch.offer(absDir);
        }
        while (!directoriesToSearch.isEmpty()) {
            nextDir = (File)directoriesToSearch.poll();
            files = nextDir.listFiles();
            if (files == null || files.length == 0) continue;
            for (File f : files) {
                absFile = f.getAbsoluteFile();
                isDir = absFile.isDirectory();
                if (isDir && processed.add(absFile)) {
                    directoriesToSearch.offer(f);
                }
                if (isDir || !filter.accept(absFile)) continue;
                if (stopOnFirstMatch) {
                    v0 /* !! */  = Collections.singleton(absFile);
                    if (v0 /* !! */  == null) lbl-1000:
                    // 2 sources

                    {
                        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.doFindFiles must not return null");
                    }
                    return v0 /* !! */ ;
                }
                found.add(absFile);
            }
        }
        ** while ((v0 /* !! */  = found) == null)
lbl36:
        // 1 sources

        return v0 /* !! */ ;
    }

    public static <C extends Collection<String>> C listFilesRecursively(@NotNull File dir, @NotNull String prefix, boolean includeDirs, int depthLimit, @Nullable Predicate<File> predicate, @NotNull C collection) {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.listFilesRecursively must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.listFilesRecursively must not be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.listFilesRecursively must not be null");
        }
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                String name;
                if (child == null || (name = child.getName()).equals(".") || name.equals("..") || predicate != null && !predicate.apply(child)) continue;
                String entry = prefix + name;
                if (child.isDirectory()) {
                    if (includeDirs) {
                        collection.add((String)entry);
                    }
                    if (depthLimit <= 0) continue;
                    FileUtil.listFilesRecursively(child, entry + '/', includeDirs, depthLimit - 1, predicate, collection);
                    continue;
                }
                collection.add((String)(prefix + name));
            }
        }
        return collection;
    }

    @NotNull
    public static File[] listFiles(@NotNull File file, @NotNull FilenameFilter filter) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.listFiles must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.listFiles must not be null");
        }
        File[] result = file.listFiles(filter);
        File[] fileArray = result != null ? result : ourEmptyFilesArray;
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.listFiles must not return null");
        }
        return fileArray;
    }

    @Nullable
    public static Long getFreeSpace(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getFreeSpace must not be null");
        }
        Method method = null;
        try {
            method = File.class.getMethod("getUsableSpace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            try {
                return (Long)method.invoke((Object)file, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Failed to compute size of file " + file + ". " + e.getMessage(), (Throwable)e);
            }
        }
        if (TeamCityProperties.getBooleanOrTrue("teamcity.use.native.free.space.command")) {
            try {
                return FileSystemUtils.freeSpaceKb((String)file.getPath()) * 1024L;
            }
            catch (Exception e) {
                LOG.warn("Failed to compute size of file " + file + ". " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File from, @NotNull File to) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copy must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.copy must not be null");
        }
        if (FileUtil.areTheSame(from, to)) {
            return;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(from), 20480);
        if (!to.exists()) {
            File parentfile = to.getParentFile();
            if (parentfile != null) {
                parentfile.mkdirs();
            }
            to.createNewFile();
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(to), 20480);
        try {
            TCStreamUtil.writeBinary(is, os);
        }
        finally {
            FileUtil.close(is);
            FileUtil.close(os);
        }
    }

    public static boolean areTheSame(@Nullable File file1, @Nullable File file2) throws IOException {
        if (file1 == null && file2 == null) {
            return true;
        }
        if (file1 == null || file2 == null) {
            return false;
        }
        File x1 = file1.getCanonicalFile();
        File x2 = file2.getCanonicalFile();
        return x1.equals(x2);
    }

    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        if (antPattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.convertAntToRegexp must not be null");
        }
        String string = FileUtil.convertAntToRegexp(antPattern, true);
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.convertAntToRegexp must not return null");
        }
        return string;
    }

    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        if (antPattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.convertAntToRegexp must not be null");
        }
        StringBuilder builder = new StringBuilder(antPattern.length());
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (antPattern.startsWith("/") || antPattern.startsWith("\\")) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|' || ch == '(' || ch == ')') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.convertAntToRegexp must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getExtension(@NotNull String fileNameWithDirectory) {
        if (fileNameWithDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getExtension must not be null");
        }
        int dotIdx = fileNameWithDirectory.lastIndexOf(".");
        int pathSeparatorIdx = Math.max(fileNameWithDirectory.lastIndexOf(47), fileNameWithDirectory.lastIndexOf(92));
        if (dotIdx == -1) return "";
        if (pathSeparatorIdx >= dotIdx) return "";
        String string = fileNameWithDirectory.substring(dotIdx + 1);
        String string2 = string;
        if (string != null) return string2;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getExtension must not return null");
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getNameWithoutExtension must not be null");
        }
        String string = FileUtil.getNameWithoutExtension(file.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getNameWithoutExtension must not return null");
        }
        return string;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.getNameWithoutExtension must not be null");
        }
        String ext = FileUtil.getExtension(name);
        String string = ext.length() > 0 ? name.substring(0, name.length() - ext.length() - 1) : name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/FileUtil.getNameWithoutExtension must not return null");
        }
        return string;
    }

    public static void setExectuableAttribute(String path, boolean executableFlag) throws IOException {
        if (IO_FILE_SET_EXECUTABLE_METHOD != null) {
            try {
                IO_FILE_SET_EXECUTABLE_METHOD.invoke((Object)new File(path), executableFlag);
                return;
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!SystemInfo.isWindows) {
            Process process = Runtime.getRuntime().exec(new String[]{"chmod", executableFlag ? "u+x" : "u-x", path});
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean checkContentEqual(@NotNull File file1, @NotNull File file2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.isAncestor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/FileUtil.isAncestor must not be null");
        }
        try {
            return com.intellij.openapi.util.io.FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowAsRuntimeException(e);
            return false;
        }
    }

    static {
        Method method;
        LOG = Logger.getInstance((String)FileUtil.class.getName());
        FILE_COMPARATOR = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.isDirectory() && o2.isFile()) {
                    return -1;
                }
                if (o1.isFile() && o2.isDirectory()) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        ourEmptyFilesArray = new File[0];
        try {
            method = File.class.getDeclaredMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_EXECUTABLE_METHOD = method;
    }

    private static class PathNormalizer {
        private final String myPath;
        private final List<String> myParts = new ArrayList<String>();
        private final StringBuilder myNextPart = new StringBuilder();

        public PathNormalizer(String path) {
            this.myPath = path;
        }

        public String invoke() {
            this.collectParts();
            return this.joinParts();
        }

        private void collectParts() {
            block3: for (int i = 0; i < this.myPath.length(); ++i) {
                char c = this.myPath.charAt(i);
                switch (c) {
                    case '/': 
                    case '\\': {
                        this.processBoundary();
                        continue block3;
                    }
                    default: {
                        this.myNextPart.append(c);
                    }
                }
            }
            this.processBoundary();
        }

        private void processBoundary() {
            if (this.myNextPart.length() > 0) {
                String val = this.myNextPart.toString();
                if ("..".equals(val)) {
                    if (this.myParts.size() > 0 && !"..".equals(this.myParts.get(this.myParts.size() - 1))) {
                        this.removeLast();
                    } else {
                        this.myParts.add(val);
                    }
                } else if (!".".equals(val)) {
                    this.myParts.add(val);
                }
                this.reset();
            }
        }

        private void removeLast() {
            this.myParts.remove(this.myParts.size() - 1);
        }

        private void reset() {
            this.myNextPart.delete(0, this.myNextPart.length());
        }

        private String joinParts() {
            return StringUtil.join("/", this.myParts);
        }
    }

    public static interface Processor {
        public void process(Element var1);
    }
}

