/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;

public class NamedThreadFactory
implements ThreadFactory {
    @NonNls
    private static final String EOL = System.getProperty("line.separator");
    private final AtomicInteger myCounter = new AtomicInteger(1);
    private final String myName;
    private final Map<Thread, Boolean> myThreads = new ConcurrentHashMap<Thread, Boolean>();

    public NamedThreadFactory(String name) {
        this.myName = name;
    }

    public static String updateThreadName(String newDetails) {
        String tc_prefix = "TC: ";
        Thread thread = Thread.currentThread();
        String currentName = thread.getName();
        if (currentName.startsWith("TC: ")) {
            thread.setName("TC: " + NamedThreadFactory.time_prefix() + newDetails + "; " + currentName.substring("TC: ".length()));
        } else {
            thread.setName("TC: " + NamedThreadFactory.time_prefix() + newDetails);
        }
        return currentName;
    }

    private static String time_prefix() {
        return new SimpleDateFormat("HH:mm:ss ").format(new Date());
    }

    public Thread newThread(Runnable r) {
        this.cleanInactive();
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setName(this.myName + " " + this.myCounter.getAndIncrement());
        this.myThreads.put(thread, Boolean.TRUE);
        return thread;
    }

    public String getThreadDump() {
        this.cleanInactive();
        StringBuilder sb = new StringBuilder();
        for (Thread thread : this.myThreads.keySet()) {
            NamedThreadFactory.appendThreadStacktrace(sb, thread);
        }
        NamedThreadFactory.appendThreadStacktrace(sb, Thread.currentThread());
        sb.append(EOL);
        return sb.toString();
    }

    private static void appendThreadStacktrace(StringBuilder sb, Thread thread) {
        StackTraceElement[] trace;
        sb.append(thread.getName()).append(EOL);
        for (StackTraceElement aTrace : trace = thread.getStackTrace()) {
            sb.append("\tat ").append(aTrace).append(EOL);
        }
    }

    private void cleanInactive() {
        for (Thread thread : new HashSet<Thread>(this.myThreads.keySet())) {
            if (thread.isAlive()) continue;
            this.myThreads.remove(thread);
        }
    }
}

