/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;
import jetbrains.buildServer.util.PEReader.InvalidSignatureException;

public class PEImageDosHeader {
    public static final int IMAGE_DOS_SIGNATURE = 23117;
    private long myPEHeaderOffset;

    private PEImageDosHeader() {
    }

    public static PEImageDosHeader read(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        int signature = BinaryUtils.readUInt16(raf);
        if (signature != 23117) {
            throw new InvalidSignatureException("DOS MZ not found");
        }
        PEImageDosHeader res = new PEImageDosHeader();
        raf.seek(60L);
        res.myPEHeaderOffset = BinaryUtils.readUInt32(raf);
        return res;
    }

    public long getPEHeaderOffset() {
        return this.myPEHeaderOffset;
    }
}

