/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;
import jetbrains.buildServer.util.PEReader.InvalidSignatureException;
import jetbrains.buildServer.util.PEReader.PEVsFixedFileInfo;

public class PEVsVersionInfo {
    public static final String KEY = "VS_VERSION_INFO";
    private int myType;
    private PEVsFixedFileInfo myFixedFileInfo;

    private PEVsVersionInfo() {
    }

    public static PEVsVersionInfo read(RandomAccessFile raf) throws IOException, InvalidSignatureException {
        PEVsVersionInfo res = new PEVsVersionInfo();
        BinaryUtils.readUInt16(raf);
        int valueLen = BinaryUtils.readUInt16(raf);
        res.myType = BinaryUtils.readUInt16(raf);
        String key = BinaryUtils.readWCHAR(raf, 40);
        if (!key.equals(KEY)) {
            throw new InvalidSignatureException("Invalid signature on PEVsVersionInfo");
        }
        if (valueLen != 0) {
            long alignedOffset = BinaryUtils.dwordAlign(raf.getFilePointer());
            raf.seek(alignedOffset);
            res.myFixedFileInfo = PEVsFixedFileInfo.read(raf);
        } else {
            res.myFixedFileInfo = null;
        }
        return res;
    }

    public int getType() {
        return this.myType;
    }

    public PEVsFixedFileInfo getFixedFileInfo() {
        return this.myFixedFileInfo;
    }
}

