/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TCStreamUtil {
    public static final boolean isWindows;

    private TCStreamUtil() {
    }

    public static void skip(InputStream input, long size) throws IOException {
        long numSkipped;
        long skipped;
        long prevSkipped = -1L;
        for (numSkipped = 0L; numSkipped < size && ((skipped = input.skip(size - numSkipped)) != 0L || prevSkipped != 0L); numSkipped += skipped) {
            prevSkipped = skipped;
        }
        if (numSkipped < size) {
            int read;
            byte[] buffer = TCStreamUtil.getByteBuffer();
            while (numSkipped < size && (read = input.read(buffer, 0, (int)Math.min((long)buffer.length, size - numSkipped))) != -1) {
                numSkipped += (long)read;
            }
        }
        if (numSkipped < size) {
            throw new EOFException("Not enough data in the stream to skip, requested: " + size + ", but skipped: " + numSkipped);
        }
    }

    public static void writeBinary(InputStream input, long length, OutputStream output) throws IOException {
        int lastRead;
        byte[] buffer = TCStreamUtil.getByteBuffer();
        for (long read = 0L; read < length; read += (long)lastRead) {
            lastRead = input.read(buffer, 0, (int)Math.min((long)buffer.length, length - read));
            if (lastRead == -1) {
                throw new EOFException();
            }
            output.write(buffer, 0, lastRead);
        }
    }

    private static byte[] getByteBuffer() {
        return new byte[8192];
    }

    public static void writeBinary(InputStream input, OutputStream output) throws IOException {
        TCStreamUtil.writeBinary(input, output, null, 0L);
    }

    public static void writeBinary(@NotNull InputStream input, @NotNull OutputStream output, @Nullable WriteProgressListener listener, long minProgressIntervalMillis) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeBinary must not be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/TCStreamUtil.writeBinary must not be null");
        }
        byte[] buffer = TCStreamUtil.getByteBuffer();
        long totalRead = 0L;
        long reportedTime = System.currentTimeMillis();
        int read = 0;
        while (read != -1) {
            read = input.read(buffer, 0, buffer.length);
            if (read == -1) continue;
            output.write(buffer, 0, read);
            if (listener == null) continue;
            if (listener.isInterrupted()) {
                throw new InterruptedIOException();
            }
            totalRead += (long)read;
            long currentTime = System.currentTimeMillis();
            if (currentTime - reportedTime < minProgressIntervalMillis) continue;
            listener.nextPortionWritten(totalRead, false);
            reportedTime = currentTime;
        }
        if (listener != null) {
            listener.nextPortionWritten(totalRead, true);
        }
    }

    public static boolean setFileMode(File file, String mode) throws IOException {
        if (isWindows || file == null || !file.exists()) {
            return true;
        }
        try {
            return TCStreamUtil.execCommand(new String[]{"chmod", mode, file.getAbsolutePath()});
        }
        catch (Throwable th) {
            throw new IOException(th.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean execCommand(String[] commandLine) throws Exception {
        Process process = Runtime.getRuntime().exec(commandLine);
        try {
            boolean bl = process.waitFor() == 0;
            return bl;
        }
        finally {
            TCStreamUtil.closeProcess(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeProcess(Process process) {
        try {
            try {
                process.getOutputStream().close();
            }
            finally {
                try {
                    process.getInputStream().close();
                }
                finally {
                    try {
                        process.getErrorStream().close();
                    }
                    finally {
                        process.destroy();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String readString(DataInputStream input) throws IOException {
        int length = input.readInt();
        if (length == -1) {
            return null;
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = input.readChar();
        }
        return new String(chars);
    }

    public static void writeString(DataOutputStream outputStream, String string) throws IOException {
        outputStream.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            outputStream.writeChar(string.charAt(i));
        }
    }

    static {
        String osName = System.getProperty("os.name");
        isWindows = osName != null && osName.toLowerCase().indexOf("windows") >= 0;
    }

    public static interface WriteProgressListener {
        public void nextPortionWritten(long var1, boolean var3);

        public boolean isInterrupted();
    }
}

