/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vars
implements Comparable<Vars> {
    private static int ourTTL_msecs = 300000;
    private static final ConcurrentMap<String, CounterValue> ourCounters = new ConcurrentHashMap<String, CounterValue>();
    private final String myActionName;
    private CounterValue myCounterHolder;

    public static void inc(String actionName) {
        new Vars(actionName).increment();
    }

    public Vars(String actionName) {
        this.myActionName = actionName;
        this.myCounterHolder = ourCounters.putIfAbsent(this.myActionName, new CounterValue());
        if (this.myCounterHolder == null) {
            this.myCounterHolder = (CounterValue)ourCounters.get(this.myActionName);
        }
    }

    void increment() {
        this.myCounterHolder.increment();
    }

    public long getCount() {
        return this.myCounterHolder.getValue();
    }

    public Date getLastModified() {
        return this.myCounterHolder.lastModified();
    }

    public String getName() {
        return this.myActionName;
    }

    public static Vars[] counters() {
        Set names = ourCounters.keySet();
        Object[] result = new Vars[names.size()];
        int i = 0;
        for (String counterName : names) {
            result[i++] = new Vars(counterName);
        }
        Arrays.sort(result);
        return result;
    }

    public static void reset() {
        ourCounters.clear();
    }

    public static void setRecentTTL(double seconds) {
        ourTTL_msecs = (int)(seconds * 1000.0);
    }

    public int getRecentCount() {
        return this.myCounterHolder.getRecentCount();
    }

    public static void dumpAsText() {
        for (Vars vars : Vars.counters()) {
            System.out.println(String.format("%5d: %s", vars.getCount(), vars.getName()));
        }
        Vars.reset();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vars that = (Vars)o;
        return this.myActionName.equals(that.myActionName);
    }

    public int hashCode() {
        return this.myActionName.hashCode();
    }

    @Override
    public int compareTo(Vars o) {
        return this.myActionName.compareTo(o.myActionName);
    }

    private static class CounterValue {
        private long myCounter;
        private Date myLastAccess;
        private final LinkedList<Date> myRecent = new LinkedList();

        private CounterValue() {
        }

        private synchronized void increment() {
            ++this.myCounter;
            this.myLastAccess = new Date();
            this.myRecent.add(this.myLastAccess);
            Date timeThreshold = new Date(this.myLastAccess.getTime() - (long)ourTTL_msecs);
            while (this.myRecent.getFirst().before(timeThreshold)) {
                this.myRecent.removeFirst();
            }
        }

        private synchronized Date lastModified() {
            return this.myLastAccess;
        }

        private synchronized long getValue() {
            return this.myCounter;
        }

        public int getRecentCount() {
            return this.myRecent.size();
        }
    }
}

