/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NonNls;

public class WatchDog {
    @NonNls
    public static final Logger LOG = Logger.getLogger(WatchDog.class);
    private long myStarted;
    private String myName;
    private final Logger myLogger;
    public static final int SEC = 1000;
    private long myDiff;
    private Priority myPriority;
    private boolean myLogIntoStdOutOnNullLogger = true;

    public WatchDog() {
        this("", null, (Priority)Level.DEBUG, false);
    }

    public WatchDog(String name) {
        this(name, null, (Priority)Level.DEBUG, true);
    }

    public WatchDog(String name, Logger logger) {
        this(name, logger, (Priority)Level.DEBUG, true);
    }

    public WatchDog(String name, Logger logger, Priority logLevel) {
        this(name, logger, logLevel, true);
    }

    public WatchDog(String name, Logger logger, Priority logLevel, boolean logIntoStdOutOnNullLogger) {
        this.myName = name;
        this.myLogger = logger;
        this.myStarted = System.nanoTime();
        this.myPriority = logLevel;
        this.myLogIntoStdOutOnNullLogger = logIntoStdOutOnNullLogger;
        this.start();
    }

    private void start() {
        this.watchAndReset("start");
    }

    public final void watch(String s) {
        this.myDiff = System.nanoTime() - this.myStarted;
        if (this.myLogger == null) {
            if (this.myLogIntoStdOutOnNullLogger) {
                System.out.println(this.line(s));
            }
        } else if (this.myLogger.isEnabledFor(this.myPriority)) {
            this.myLogger.log(this.myPriority, (Object)this.line(s));
        }
    }

    public String current() {
        return WatchDog.diff((System.nanoTime() - this.myStarted) / 1000000L);
    }

    private String line(String s) {
        return this.myName + ' ' + s + ": " + WatchDog.diff(this.getTimeMsecs());
    }

    public final void stop() {
        this.watchAndReset("stopped");
    }

    public final void watchAndReset(String s) {
        this.watch(s);
        this.myStarted = System.nanoTime();
    }

    private static String diff(long mseconds) {
        StringBuilder builder = new StringBuilder();
        if (mseconds >= 1000L) {
            builder.append(mseconds / 1000L).append(" sec ").append(mseconds % 1000L).append(" msec");
        } else {
            builder.append(mseconds).append(" msec");
        }
        return builder.toString();
    }

    public long getTimeMsecs() {
        return this.myDiff / 1000000L;
    }

    public long getTimeNanosec() {
        return this.myDiff;
    }
}

