/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.fileLookup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jetbrains.buildServer.util.fileLookup.FileInfo;
import jetbrains.buildServer.util.fileLookup.MemorizingLookup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemorizingZipFileLookup
extends MemorizingLookup<FileInfo, String, ZipEntry> {
    @NotNull
    private final ZipFile myZip;

    public MemorizingZipFileLookup(final @NotNull ZipFile zip) {
        if (zip == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup.<init> must not be null");
        }
        super(new Iterable<ZipEntry>(){
            @NotNull
            private final Enumeration<? extends ZipEntry> e;
            {
                this.e = zip.entries();
            }

            @Override
            public Iterator<ZipEntry> iterator() {
                return new Iterator<ZipEntry>(){
                    @Nullable
                    private ZipEntry myNext;

                    @Override
                    public boolean hasNext() {
                        if (this.myNext != null) {
                            return true;
                        }
                        while (e.hasMoreElements()) {
                            ZipEntry next = (ZipEntry)e.nextElement();
                            if (!next.isDirectory()) continue;
                            this.myNext = next;
                            break;
                        }
                        return this.myNext != null;
                    }

                    @Override
                    public ZipEntry next() {
                        if (!this.hasNext()) {
                            throw new IllegalStateException("No more elements");
                        }
                        ZipEntry next = this.myNext;
                        this.myNext = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove operation is not supported");
                    }
                };
            }
        });
        this.myZip = zip;
    }

    @Override
    @Nullable
    protected String lookupInside(@NotNull ZipEntry place, @NotNull FileInfo fileInfo) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup.lookupInside must not be null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup.lookupInside must not be null");
        }
        String path = place.getName();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.endsWith(fileInfo.getParentPath())) {
            return null;
        }
        for (String name : fileInfo.getPossibleFileNames()) {
            String fileName = path + "/" + name;
            ZipEntry found = this.myZip.getEntry(fileName);
            if (found == null) continue;
            return this.myZip.getName() + ":" + fileName;
        }
        return null;
    }

    @NotNull
    public static FileInfo createFileInfo(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup.createFileInfo must not be null");
        }
        int slashIndex = (filePath = filePath.replace("\\", "/")).lastIndexOf("/");
        final String parentPath = slashIndex == -1 ? "" : filePath.substring(0, slashIndex);
        final List<String> possibleFileNames = Arrays.asList(slashIndex == -1 ? filePath : filePath.substring(slashIndex + 1));
        FileInfo fileInfo = new FileInfo(){

            @Override
            @NotNull
            public String getParentPath() {
                String string = parentPath;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup$2.getParentPath must not return null");
                }
                return string;
            }

            @Override
            @NotNull
            public Collection<String> getPossibleFileNames() {
                Collection collection = possibleFileNames;
                if (collection == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup$2.getPossibleFileNames must not return null");
                }
                return collection;
            }
        };
        if (fileInfo == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup.createFileInfo must not return null");
        }
        return fileInfo;
    }
}

