/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtil {
    private FilterUtil() {
    }

    @NotNull
    public static <T> Filter<T> not(final @NotNull Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.not must not be null");
        }
        Filter filter2 = new Filter<T>(){

            @Override
            public boolean accept(@NotNull T data) {
                if (data == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil$1.accept must not be null");
                }
                return !filter.accept(data);
            }
        };
        if (filter2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/filters/FilterUtil.not must not return null");
        }
        return filter2;
    }

    public static <E, T extends Collection<? extends E>> T filterCollection(@NotNull T collection, @NotNull Filter<E> filter) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterCollection must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterCollection must not be null");
        }
        if (collection instanceof ArrayList) {
            return (T)FilterUtil.filterArrayList((ArrayList)collection, filter);
        }
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (filter.accept(e)) continue;
            it.remove();
        }
        return collection;
    }

    @NotNull
    public static <E, T extends E> ArrayList<T> filterArrayList(@NotNull ArrayList<T> original, @NotNull Filter<E> filter) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterArrayList must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterArrayList must not be null");
        }
        ArrayList<T> accepted = null;
        for (int i = 0; i < original.size(); ++i) {
            T t = original.get(i);
            if (filter.accept(t)) {
                if (accepted == null) continue;
                accepted.add(t);
                continue;
            }
            if (accepted != null) continue;
            accepted = new ArrayList<T>(original.size() - 1);
            accepted.addAll(original.subList(0, i));
        }
        if (accepted != null) {
            original.clear();
            original.addAll(accepted);
        }
        ArrayList<T> arrayList = original;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/filters/FilterUtil.filterArrayList must not return null");
        }
        return arrayList;
    }

    public static <Key, Value, T extends Map<Key, Value>> T filterMapByKey(@NotNull T map, @NotNull Filter<Key> filter) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterMapByKey must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterMapByKey must not be null");
        }
        Iterator<Key> it = map.keySet().iterator();
        while (it.hasNext()) {
            Key key = it.next();
            if (filter.accept(key)) continue;
            it.remove();
        }
        return map;
    }

    public static <Key, Value, T extends Map<Key, Value>> T filterMapByValue(@NotNull T map, @NotNull Filter<Value> filter) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterMapByValue must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterMapByValue must not be null");
        }
        Iterator<Key> it = map.keySet().iterator();
        while (it.hasNext()) {
            Key key = it.next();
            Value val = map.get(key);
            if (filter.accept(val)) continue;
            it.remove();
        }
        return map;
    }

    public static <Key, Value, Source extends Map<? extends Key, ? extends Value>, Target extends Map<? super Key, ? super Value>> Target filterMapByKeyAndCopy(@NotNull Source sourceMap, @NotNull Target targetMap, @NotNull Filter<? super Key> filter) {
        if (sourceMap == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterMapByKeyAndCopy must not be null");
        }
        if (targetMap == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterMapByKeyAndCopy must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterMapByKeyAndCopy must not be null");
        }
        for (Map.Entry<Key, Value> entry : sourceMap.entrySet()) {
            Key key = entry.getKey();
            if (!filter.accept(key)) continue;
            targetMap.put(key, entry.getValue());
        }
        return targetMap;
    }

    public static <C extends Collection<? super T>, T> C filterAndCopy(@NotNull Iterable<T> source, @NotNull C target, @NotNull Filter<? super T> filter) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterAndCopy must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterAndCopy must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/filters/FilterUtil.filterAndCopy must not be null");
        }
        for (T k : source) {
            if (!filter.accept(k)) continue;
            target.add(k);
        }
        return target;
    }
}

