/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.dataStructures.MultiMapToSet;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionAwareSortedCollection<T> {
    private static final Logger LOG = Logger.getInstance((String)PositionAwareSortedCollection.class.getName());
    private final Collection<Node<T>> myFirstNodes = new ArrayList<Node<T>>();
    private final Collection<Node<T>> myLastNodes = new ArrayList<Node<T>>();
    private final Collection<Node<T>> myNodes = new ArrayList<Node<T>>();
    private final MultiMapToSet<String, String> myBeforeConstratins = new MultiMapToSet();
    private final Set<String> myIds = new HashSet<String>();
    private final Set<String> myNotExisting = new HashSet<String>();
    private final Function<Node<T>, String> NODE_TO_STRING = new Function<Node<T>, String>(){

        public String fun(Node<T> node) {
            return node.getId();
        }
    };

    public void add(@NotNull T item, @NotNull String id, @NotNull PositionConstraint constraint) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.add must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.add must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.add must not be null");
        }
        Node<T> node = new Node<T>(item, id);
        this.myIds.add(id);
        this.myNotExisting.remove(id);
        if (constraint.isFirst()) {
            this.myFirstNodes.add(node);
            return;
        }
        if (constraint.isLast()) {
            this.myLastNodes.add(node);
            return;
        }
        this.myNodes.add(node);
        for (String s : constraint.getBefore()) {
            this.myBeforeConstratins.add(s, id);
            if (this.myIds.contains(s)) continue;
            this.myNotExisting.add(s);
        }
        for (String s : constraint.getAfter()) {
            this.myBeforeConstratins.add(id, s);
            if (this.myIds.contains(s)) continue;
            this.myNotExisting.add(s);
        }
    }

    public boolean removeWhere(@NotNull Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.removeWhere must not be null");
        }
        boolean found = false;
        for (Collection nodes : Arrays.asList(this.myFirstNodes, this.myLastNodes, this.myNodes)) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!filter.accept(node.getItem())) continue;
                found = true;
                it.remove();
                String id = node.getId();
                this.myIds.remove(id);
                this.myBeforeConstratins.removeValue(id);
                this.myBeforeConstratins.removeKey(id);
            }
        }
        return found;
    }

    public boolean isEmpty() {
        return this.myIds.isEmpty();
    }

    public int size() {
        return this.myLastNodes.size() + this.myFirstNodes.size() + this.myNodes.size();
    }

    public void clear() {
        this.myFirstNodes.clear();
        this.myLastNodes.clear();
        this.myNodes.clear();
        this.myIds.clear();
        this.myBeforeConstratins.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<T> getSorted() {
        List list;
        if (this.isEmpty()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.getSorted must not return null");
            return list;
        }
        LinkedList<Node<T>> nodes = new LinkedList<Node<T>>(this.myNodes);
        ArrayList<Node<T>> result = new ArrayList<Node<T>>(this.size());
        HashSet<String> added = new HashSet<String>(3 * this.size() + this.myNotExisting.size() * 2);
        added.addAll(this.myNotExisting);
        for (Node<T> note : this.myFirstNodes) {
            added.add(note.getId());
        }
        while (!nodes.isEmpty()) {
            boolean mayContinue = false;
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!added.containsAll(this.myBeforeConstratins.getValues(node.getId()))) continue;
                it.remove();
                this.addNodeToResult(result, added, node);
                mayContinue = true;
                break;
            }
            if (mayContinue || nodes.size() <= 0) continue;
            LOG.warn("Dependency cycle detected among ordered items: " + this.nodesToString(nodes) + ", order is unpredictable");
            Node<T> node = nodes.remove(0);
            this.addNodeToResult(result, added, node);
        }
        this.myNodes.clear();
        this.myNodes.addAll(result);
        list = this.createResultCollection(result);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.getSorted must not return null");
    }

    private String nodesToString(List<Node<T>> nodes) {
        if (nodes.isEmpty()) {
            return "<empty>";
        }
        return StringUtil.join(nodes, this.NODE_TO_STRING, (String)", ");
    }

    @NotNull
    private List<T> createResultCollection(@NotNull List<Node<T>> result) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.createResultCollection must not be null");
        }
        ArrayList items = new ArrayList(this.size());
        for (Collection nodes : Arrays.asList(this.myFirstNodes, result, this.myLastNodes)) {
            for (Node node : nodes) {
                items.add(node.getItem());
            }
        }
        ArrayList arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.createResultCollection must not return null");
        }
        return arrayList;
    }

    private void addNodeToResult(@NotNull Collection<Node<T>> result, @NotNull Set<String> added, @NotNull Node<T> node) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.addNodeToResult must not be null");
        }
        if (added == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.addNodeToResult must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection.addNodeToResult must not be null");
        }
        added.add(node.getId());
        result.add(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        private final String myId;
        private final T myItem;

        public Node(@NotNull T item, @NotNull String id) {
            if (item == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node.<init> must not be null");
            }
            if (id == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node.<init> must not be null");
            }
            this.myItem = item;
            this.myId = id;
        }

        @NotNull
        public T getItem() {
            T t = this.myItem;
            if (t == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node.getItem must not return null");
            }
            return t;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node.getId must not return null");
            }
            return string;
        }

        public String toString() {
            return "Node{myId='" + this.myId + '\'' + '}';
        }
    }
}

