/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.FileRule;
import jetbrains.buildServer.vcs.FileRuleSet;
import jetbrains.buildServer.vcs.IncludeRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutRules
extends FileRuleSet<IncludeRule, FileRule> {
    public static final CheckoutRules DEFAULT = new CheckoutRules("");
    public static final String INCLUDE_SEP = "=>";

    public CheckoutRules(List<String> body) {
        super(body);
    }

    public CheckoutRules(String body) {
        super(body);
    }

    public CheckoutRules(List<IncludeRule> includeRules, List<FileRule> excludeRules) {
        super(includeRules, excludeRules);
    }

    @Nullable
    public String map(String path) {
        IncludeRule rule;
        boolean includeAll = this.isIncludeAll();
        if (!includeAll && !this.shouldInclude(path)) {
            return null;
        }
        path = CheckoutRules.preparePath(path);
        IncludeRule includeRule = rule = includeAll ? (IncludeRule)this.getIncludeRules().get(0) : (IncludeRule)this.findMostSpecific(path, this.getIncludeRules());
        if (rule != null) {
            return rule.map(path);
        }
        throw new RuntimeException("Cannot map file path '" + path + "; : include rule not found " + this.toString());
    }

    private boolean isIncludeAll() {
        List includeRules = this.getIncludeRules();
        List excludeRules = this.getExcludeRules();
        return excludeRules.size() == 0 && includeRules.size() == 1 && ((IncludeRule)includeRules.get(0)).getFrom().length() == 0;
    }

    public static CheckoutRules createCommonRule(List<CheckoutRules> ruleses) {
        List<IncludeRule> includes = CheckoutRules.buildIncludeUnion(ruleses);
        List<FileRule> excludes = CheckoutRules.buildExcludeIntersection(ruleses);
        ArrayList<FileRule> allRules = new ArrayList<FileRule>();
        allRules.addAll(includes);
        allRules.addAll(excludes);
        CheckoutRules.sortByFrom(allRules, false);
        CheckoutRules.filterIncludes(allRules);
        CheckoutRules.sortByFrom(allRules, true);
        CheckoutRules.filterExcludes(allRules);
        CheckoutRules.replaceIncludeToPart(allRules);
        return new CheckoutRules(CheckoutRules.toString(allRules));
    }

    private static void replaceIncludeToPart(List<FileRule> allRules) {
        for (int i = 0; i < allRules.size(); ++i) {
            FileRule rule = allRules.get(i);
            if (!(rule instanceof IncludeRule)) continue;
            IncludeRule includeRule = (IncludeRule)rule;
            IncludeRule newRule = new IncludeRule(includeRule.getFrom(), includeRule.getFrom(), null);
            allRules.set(i, newRule);
        }
    }

    private static void filterExcludes(List<FileRule> allRules) {
        String prevFrom = null;
        Iterator<FileRule> iterator = allRules.iterator();
        while (iterator.hasNext()) {
            FileRule rule = iterator.next();
            if (rule.isIsInclude()) {
                prevFrom = null;
                continue;
            }
            if (prevFrom != null && CheckoutRules.isSubDir(prevFrom, rule.getFrom())) {
                iterator.remove();
                continue;
            }
            prevFrom = rule.getFrom();
        }
    }

    private static void filterIncludes(List<FileRule> allRules) {
        String prevFrom = null;
        Iterator<FileRule> iterator = allRules.iterator();
        while (iterator.hasNext()) {
            FileRule rule = iterator.next();
            if (!(rule instanceof IncludeRule)) {
                prevFrom = null;
                continue;
            }
            if (prevFrom != null && CheckoutRules.isSubDir(rule.getFrom(), prevFrom)) {
                iterator.remove();
                continue;
            }
            prevFrom = rule.getFrom();
        }
    }

    @NotNull
    private static List<FileRule> buildExcludeIntersection(@NotNull List<CheckoutRules> ruleses) {
        if (ruleses == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/CheckoutRules.buildExcludeIntersection must not be null");
        }
        LinkedHashSet<String> selectedPaths = new LinkedHashSet<String>();
        for (CheckoutRules rules : ruleses) {
            for (FileRule excludeRule : rules.getExcludeRules()) {
                String from = excludeRule.getFrom();
                boolean included = true;
                for (CheckoutRules otherRules : ruleses) {
                    if (rules == otherRules || CheckoutRules.isPathIncluded(from, otherRules)) continue;
                    included = false;
                    break;
                }
                if (!included) continue;
                selectedPaths.add(from);
            }
        }
        ArrayList<FileRule> result = new ArrayList<FileRule>();
        for (String from : selectedPaths) {
            result.add(new FileRule<Object>(from, null, false));
        }
        ArrayList<FileRule> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/CheckoutRules.buildExcludeIntersection must not return null");
        }
        return arrayList;
    }

    private static boolean isPathIncluded(@NotNull String path, @NotNull CheckoutRules parents) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/CheckoutRules.isPathIncluded must not be null");
        }
        if (parents == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/CheckoutRules.isPathIncluded must not be null");
        }
        List excludeRules = parents.getExcludeRules();
        if (excludeRules.isEmpty()) {
            return false;
        }
        for (FileRule parent : excludeRules) {
            if (!CheckoutRules.isSubDir(path, parent.getFrom())) continue;
            return true;
        }
        return false;
    }

    private static List<String> toString(List<FileRule> rules) {
        ArrayList<String> result = new ArrayList<String>();
        for (FileRule rule : rules) {
            result.add(rule.toString());
        }
        return result;
    }

    private static List<IncludeRule> buildIncludeUnion(List<CheckoutRules> checkoutRuleses) {
        ArrayList<IncludeRule> result = new ArrayList<IncludeRule>();
        for (CheckoutRules checkoutRules : checkoutRuleses) {
            result.addAll(checkoutRules.getIncludeRules());
        }
        return result;
    }

    public String toString() {
        return this.asString();
    }

    public String getAsString() {
        StringBuilder result = new StringBuilder();
        for (String line : this.getBody()) {
            if (line.length() <= 0) continue;
            result.append(line);
            if (line.endsWith("\n")) continue;
            result.append('\n');
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == '\n') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private String asString() {
        StringBuffer result = new StringBuffer();
        for (IncludeRule includeRule : this.getIncludeRules()) {
            result.append(includeRule.toString()).append('\n');
        }
        for (FileRule excludeRule : this.getExcludeRules()) {
            result.append(excludeRule.toString()).append('\n');
        }
        return result.toString();
    }

    public static boolean isCorrect(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/CheckoutRules.isCorrect must not be null");
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0) {
            return true;
        }
        if (trimmed.startsWith(":")) {
            return false;
        }
        if (trimmed.startsWith("-:") && line.indexOf(INCLUDE_SEP) != -1) {
            return false;
        }
        return !trimmed.equals("+:") && !trimmed.equals("-:") && !trimmed.equals(INCLUDE_SEP);
    }

    public List<IncludeRule> getRootIncludeRules() {
        ArrayList<IncludeRule> result = new ArrayList<IncludeRule>();
        result.addAll(this.getIncludeRules());
        CheckoutRules.sortByFrom(result, false);
        HashSet<IncludeRule> processedRules = new HashSet<IncludeRule>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            IncludeRule includeRule = (IncludeRule)iterator.next();
            if (!this.shouldInclude(includeRule.getFrom())) {
                iterator.remove();
                continue;
            }
            if (!StringUtil.isEmpty((String)includeRule.getTo()) && !includeRule.getTo().equals(includeRule.getFrom())) continue;
            for (IncludeRule processed : processedRules) {
                if (!CheckoutRules.isSubDir(includeRule.getFrom(), processed.getFrom())) continue;
                iterator.remove();
                break;
            }
            processedRules.add(includeRule);
        }
        return result;
    }

    public CheckoutRules createNewRulesForPrefix(String prefixPath) {
        if (prefixPath.length() == 0) {
            return this;
        }
        ArrayList<String> rules = new ArrayList<String>();
        for (IncludeRule includeRule : this.getIncludeRules()) {
            String to = includeRule.getTo();
            if (to.length() == 0) {
                to = ".";
            }
            if (includeRule.getFrom().length() == 0) {
                rules.add(prefixPath + INCLUDE_SEP + to);
                continue;
            }
            rules.add(prefixPath + "/" + includeRule.getFrom() + INCLUDE_SEP + to);
        }
        for (FileRule excludeRule : this.getExcludeRules()) {
            if (excludeRule.getFrom().length() == 0) {
                rules.add("-:" + prefixPath);
                continue;
            }
            rules.add("-:" + prefixPath + "/" + excludeRule.getFrom());
        }
        return new CheckoutRules(rules);
    }

    @Override
    protected void postProcessCreatedRules(List<IncludeRule> includeRules, List<FileRule> excludeRules) {
        super.postProcessCreatedRules(includeRules, excludeRules);
        for (IncludeRule includeRule : includeRules) {
            Iterator<FileRule> iterator = excludeRules.iterator();
            while (iterator.hasNext()) {
                FileRule excludeRule = iterator.next();
                if (!excludeRule.getFrom().equals(includeRule.getFrom())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    protected void doPostInitProcess(List<IncludeRule> includeRules, List<FileRule> excludeRules) {
        CheckoutRules.sortByFrom(includeRules, true);
        CheckoutRules.sortByFrom(excludeRules, true);
    }

    @Override
    protected IncludeRule createNewIncludeRule(String rule) {
        int sepIndex = rule.indexOf(INCLUDE_SEP);
        if (sepIndex < 0) {
            return new IncludeRule(rule, rule, this);
        }
        String from = rule.substring(0, sepIndex).trim();
        String to = rule.substring(sepIndex + INCLUDE_SEP.length()).trim();
        return new IncludeRule(from, to, this);
    }

    @Override
    protected FileRule createNewExcludeRule(String line) {
        return new FileRule<CheckoutRules>(line, this, false);
    }

    @Override
    protected IncludeRule createNewIncludeRule(IncludeRule includeRule) {
        return new IncludeRule(includeRule.getFrom(), includeRule.getTo(), this);
    }

    @Override
    protected FileRule createNewExcludeRule(FileRule includeRule) {
        return new FileRule<CheckoutRules>(includeRule.getFrom(), this, true);
    }

    public static CheckoutRules createOn(String ruleStr) {
        return new CheckoutRules(ruleStr);
    }

    public boolean containsWildcards() {
        for (IncludeRule includeRule : this.getIncludeRules()) {
            if (includeRule.getFrom().contains("*")) {
                return true;
            }
            if (!includeRule.getTo().contains("*")) continue;
            return true;
        }
        for (FileRule fileRule : this.getExcludeRules()) {
            if (!fileRule.getFrom().contains("*")) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CheckoutRules)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

