/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.TCStringUtil;
import jetbrains.buildServer.vcs.FileRuleSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRule<ParentRules extends FileRuleSet> {
    protected final String myFromPath;
    protected final String myFromFull;
    private final ParentRules myParentRules;
    protected final Pattern myPattern;
    private final boolean myIsInclude;
    private static final String STANDARD_TAIL = "(\\/.*)*";
    private Map<String, String> myAdditionalProperties;

    public FileRule(String from, ParentRules parentRules, boolean isInclude) {
        String fromPath;
        this.myFromFull = from;
        if (from.contains(":")) {
            from = this.readAdditionalProperties(from);
        }
        if ((fromPath = FileRule.prepareRulePath(from)).equals(this.myFromFull)) {
            fromPath = this.myFromFull;
        }
        this.myFromPath = fromPath;
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myPattern = this.compilePattern();
    }

    @Nullable
    private Pattern compilePattern() {
        if (this.myFromPath.endsWith("*") || this.myFromPath.endsWith("**")) {
            return Pattern.compile(this.createPatternString(this.myFromPath));
        }
        if (this.myFromPath.length() == 0) {
            return null;
        }
        return Pattern.compile(this.createPatternString(this.myFromPath) + STANDARD_TAIL);
    }

    public FileRule(@NotNull String fromPath, @Nullable String additionalProperties, @NotNull ParentRules parentRules, boolean isInclude) {
        if (fromPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/FileRule.<init> must not be null");
        }
        if (parentRules == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/FileRule.<init> must not be null");
        }
        this.myFromPath = FileRule.prepareRulePath(fromPath);
        this.myFromFull = fromPath + (additionalProperties == null ? "" : ":" + additionalProperties);
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myPattern = this.compilePattern();
    }

    private String readAdditionalProperties(String from) {
        int lastSeparator = from.lastIndexOf(":");
        String properties = from.substring(0, lastSeparator);
        this.myAdditionalProperties = TCStringUtil.readProperties(properties, ";", "=");
        return from.substring(lastSeparator + 1);
    }

    protected static String prepareRulePath(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        return FileUtil.normalizeRelativePath(path);
    }

    protected String createPatternString(String from) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < from.length(); ++i) {
            char nextChar = from.charAt(i);
            if (nextChar == '\\') {
                result.append("\\/");
                continue;
            }
            if (nextChar == '?') {
                result.append(".");
                continue;
            }
            if (nextChar == '$' || nextChar == '(' || nextChar == '{' || nextChar == ')' || nextChar == '}' || nextChar == '[' || nextChar == ']' || nextChar == '/' || nextChar == '.' || nextChar == '+') {
                result.append("\\").append(nextChar);
                continue;
            }
            if (nextChar == '*') {
                if (i < from.length() - 1 && from.charAt(i + 1) == '*') {
                    result.append("(.*)");
                    ++i;
                    continue;
                }
                result.append("([^/]*)");
                continue;
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    public String getFrom() {
        return this.myFromPath;
    }

    public ParentRules getParentRules() {
        return this.myParentRules;
    }

    public boolean isIsInclude() {
        return this.myIsInclude;
    }

    public String toString() {
        if (this.myIsInclude) {
            return this.myFromFull;
        }
        return "-:" + this.myFromFull;
    }

    @Nullable
    public String getMatchedHead(String path) {
        if (this.myPattern == null) {
            return "";
        }
        Matcher matcher = this.myPattern.matcher(path);
        if (matcher.matches()) {
            int groupCount = matcher.groupCount();
            String lastGroup = matcher.group(groupCount);
            if (lastGroup != null) {
                return FileRule.prepareRulePath(path.substring(0, path.length() - lastGroup.length()));
            }
            return FileRule.prepareRulePath(path);
        }
        return null;
    }

    @Nullable
    public String getProperty(String propName) {
        if (this.myAdditionalProperties == null) {
            return null;
        }
        return this.myAdditionalProperties.get(propName);
    }

    public boolean propertiesMatch(Map<String, String> props) {
        if (this.myAdditionalProperties == null) {
            return true;
        }
        for (String name : this.myAdditionalProperties.keySet()) {
            String expectedProp = this.myAdditionalProperties.get(name);
            String actualProp = props.get(name);
            if (expectedProp == null || expectedProp.equals(actualProp)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Map<String, String> getAdditionalProperties() {
        return this.myAdditionalProperties;
    }

    public boolean isAbsolutePath() {
        return this.myFromFull.startsWith("/");
    }
}

