/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xmlrpc.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import jetbrains.buildServer.xmlrpc.XmlRpcLogger;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcTransport;

public class MyXmlRpcTransport
implements XmlRpcTransport {
    private PostMethod myMethod;
    private final URL myUrl;
    private final String myUserAgent;
    private final boolean myKeepAlive;
    private final HttpClient myClient;
    private final HttpMethodRetryHandler myRetryHandler;
    private final Logger myLogger = XmlRpcLogger.getLogger();

    public MyXmlRpcTransport(URL url, String userAgent, HttpClient client, HttpMethodRetryHandler retryHandler, boolean keepAlive) {
        this.myUrl = url;
        this.myClient = client;
        this.myUserAgent = userAgent;
        this.myKeepAlive = keepAlive;
        this.myRetryHandler = retryHandler == null ? new DefaultHttpMethodRetryHandler(0, false) : retryHandler;
    }

    public void endClientRequest() throws XmlRpcClientException {
        this.myMethod.releaseConnection();
    }

    public InputStream sendXmlRpc(byte[] request) throws IOException, XmlRpcClientException {
        String lValue;
        if (this.myLogger.isDebugEnabled()) {
            this.myLogger.debug((Object)">>> XML-RPC request >>>");
            this.myLogger.debug((Object)new String(request, "UTF-8"));
        }
        this.myMethod = new PostMethod(this.myUrl.toString());
        this.myMethod.addRequestHeader("User-Agent", this.myUserAgent);
        this.myMethod.getParams().setVersion(this.myKeepAlive ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0);
        this.myMethod.getParams().setParameter("http.method.retry-handler", (Object)this.myRetryHandler);
        this.myMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(request, "text/xml"));
        int status = this.myClient.executeMethod((HttpMethod)this.myMethod);
        if (status != 200) {
            if (status == 503) {
                throw new IOException("Server returned status 503 (service unavailable), try later");
            }
            StatusLine statusLine = this.myMethod.getStatusLine();
            if (statusLine != null) {
                String message = "Server returned incorrect status code: " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase();
                throw new XmlRpcClientException(message, null);
            }
        }
        boolean lgzipo = false;
        Header lHeader = this.myMethod.getResponseHeader("Content-Encoding");
        if (lHeader != null && (lValue = lHeader.getValue()) != null) {
            lgzipo = lValue.indexOf("gzip") >= 0;
        }
        InputStream result = lgzipo ? new GZIPInputStream(this.myMethod.getResponseBodyAsStream()) : this.myMethod.getResponseBodyAsStream();
        if (this.myLogger.isDebugEnabled()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int data = result.read();
            while (data != -1) {
                bos.write(data);
                data = result.read();
            }
            this.myLogger.debug((Object)"<<< XML-RPC response <<<");
            this.myLogger.debug((Object)bos.toString("UTF-8"));
            byte[] bytes = bos.toByteArray();
            result = new ByteArrayInputStream(bytes);
        }
        return result;
    }

    public void disposeConnections() {
        HttpConnectionManager cm = this.myClient.getHttpConnectionManager();
        if (cm == null) {
            return;
        }
        cm.closeIdleConnections(0L);
    }
}

