/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcTransport;
import org.apache.xmlrpc.util.HttpUtil;

public class TCDefaultXmlRpcTransport
implements XmlRpcTransport {
    protected URL url;
    protected String userAgent;
    protected String auth;
    protected URLConnection con;
    private int myTimeout = -1;

    public TCDefaultXmlRpcTransport(URL url, String userAgent) {
        this.url = url;
        this.userAgent = userAgent;
    }

    public InputStream sendXmlRpc(byte[] request) throws IOException {
        this.con = this.url.openConnection();
        this.con.setDoInput(true);
        this.con.setDoOutput(true);
        this.con.setUseCaches(false);
        this.con.setAllowUserInteraction(false);
        if (this.myTimeout > 0) {
            this.setTimeoutToConnection(this.con, this.myTimeout);
        }
        this.con.setRequestProperty("User-Agent", this.userAgent);
        this.con.setRequestProperty("Content-Length", Integer.toString(request.length));
        this.con.setRequestProperty("Content-Type", "text/xml");
        if (this.auth != null) {
            this.con.setRequestProperty("Authorization", "Basic " + this.auth);
        }
        OutputStream out = this.con.getOutputStream();
        out.write(request);
        out.flush();
        out.close();
        return this.con.getInputStream();
    }

    private void setTimeoutToConnection(URLConnection con, int timeout) {
        try {
            Method setTimeout = con.getClass().getDeclaredMethod("setConnectTimeout", Integer.TYPE);
            setTimeout.invoke((Object)con, new Integer(timeout));
            Method readTimeout = con.getClass().getDeclaredMethod("setReadTimeout", Integer.TYPE);
            readTimeout.invoke((Object)con, new Integer(2 * timeout));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBasicAuthentication(String user, String password) {
        this.auth = HttpUtil.encodeBasicAuthentication((String)user, (String)password);
    }

    public void endClientRequest() throws XmlRpcClientException {
        try {
            this.con.getInputStream().close();
        }
        catch (Exception e) {
            throw new XmlRpcClientException("Exception closing URLConnection", (Throwable)e);
        }
    }

    public void setTimeout(int timeout) {
        this.myTimeout = timeout;
    }
}

