/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.data;

import com.accurev.common.data.FieldData;
import com.accurev.common.data.StreamData;
import com.accurev.common.data.UserData;
import com.accurev.common.data.XMLTag;
import com.accurev.common.process.StreamProcess;
import com.accurev.common.utils.FileUtilities;
import com.accurev.common.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ChangePackageData {
    protected String depotName = "";
    protected String streamName = "";
    protected UserData userData = null;
    protected boolean enabled = false;
    protected List columnNames = new ArrayList();
    protected boolean queryContainsCurrentDate = false;
    protected String accuWorkIssueQueryPath = null;
    private static final String actionsKey = "actions";
    private static final String andKey = "AND";
    private static final String conditionKey = "condition";
    private static final String docKey = "doc";
    private static final String fieldKey = "field";
    private static final String ifKey = "if";
    private static final String issueDBKey = "issueDB";
    private static final String issueNumberKey = "issueNum";
    private static final String orKey = "OR";
    private static final String queryKey = "query";
    private static final String queryIssueKey = "queryIssue";
    private static final String termKey = "term";
    private static final String useAltKey = "useAlt";
    private static final String useAltQueryKey = "useAltQuery";
    private static final String validationKey = "validation";
    private static final String equalsCondition = "==";
    private static final String notEqualsCondition = "!=";
    private static final String isInHierarchyCondition = "isInHierarchy";
    private static final String isNotInHierarchyCondition = "isNotInHierarchy";

    public ChangePackageData(String depotName, String streamName, UserData userData) {
        this.depotName = depotName;
        this.streamName = streamName;
        this.userData = userData;
        StreamProcess process = new StreamProcess();
        List tagList = process.runGetConfigChangePackage(depotName);
        this.extractChangePackageInformation(tagList);
    }

    public String getDepotName() {
        return this.depotName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List getColumnNames() {
        return this.columnNames;
    }

    public boolean getQueryContainsCurrentDate() {
        return this.queryContainsCurrentDate;
    }

    public String getAccuWorkIssueQueryPath() {
        return this.accuWorkIssueQueryPath;
    }

    public boolean isQueryValid() {
        return this.accuWorkIssueQueryPath != null;
    }

    protected void extractChangePackageInformation(List tagList) {
        if (tagList == null || tagList.size() == 0) {
            return;
        }
        XMLTag docTag = (XMLTag)tagList.get(0);
        if (!docTag.getName().equalsIgnoreCase(docKey)) {
            return;
        }
        XMLTag validationTag = docTag.getTag(validationKey);
        if (validationTag == null) {
            return;
        }
        List ifKeyList = validationTag.getTags(ifKey);
        if (ifKeyList.isEmpty()) {
            return;
        }
        for (int ikIndex = 0; ikIndex < ifKeyList.size(); ++ikIndex) {
            XMLTag conditionTag;
            List fieldList;
            XMLTag queryTag;
            XMLTag actionsTag;
            XMLTag ifTag = (XMLTag)ifKeyList.get(ikIndex);
            if (ifTag == null || (actionsTag = ifTag.getTag(actionsKey)) == null || (queryTag = actionsTag.getTag(queryKey)) == null) continue;
            if (this.columnNames.size() == 0 && (fieldList = queryTag.getTags(fieldKey)).size() > 0) {
                this.columnNames.addAll(FieldData.getColumnInformation(fieldList, this.depotName));
            }
            if ((conditionTag = ifTag.getTag(conditionKey)) == null) continue;
            XMLTag andTag = conditionTag.getTag(andKey);
            XMLTag orTag = conditionTag.getTag(orKey);
            if (andTag == null && orTag == null) continue;
            if (andTag != null) {
                this.enabled = this.compareCondition(andTag, this.depotName, this.streamName);
            } else if (orTag != null) {
                this.enabled = this.compareCondition(orTag, this.depotName, this.streamName);
            }
            if (!this.enabled) continue;
            XMLTag queryIssueTag = queryTag.getTag(queryIssueKey);
            if (queryIssueTag == null) break;
            queryIssueTag.addAttribute(issueDBKey, this.depotName);
            queryIssueTag.addAttribute(useAltKey, "false");
            queryIssueTag.addAttribute(useAltQueryKey, "false");
            String xmlBuffer = queryIssueTag.toXML();
            xmlBuffer = StringUtilities.replaceAll(xmlBuffer, "CUR_USER", this.userData.getNumber());
            this.queryContainsCurrentDate = xmlBuffer.indexOf("CUR_DATE") >= 0;
            this.accuWorkIssueQueryPath = FileUtilities.createTemporaryFile(xmlBuffer);
            break;
        }
        this.checkForQueryColumns();
    }

    protected boolean compareCondition(XMLTag conditionTag, String depotName, String streamName) {
        boolean isAndCondition;
        List tagList = conditionTag.getTags();
        if (tagList.size() == 0) {
            return true;
        }
        boolean result = isAndCondition = conditionTag.getName().equalsIgnoreCase(andKey);
        for (int findx = 0; findx < tagList.size(); ++findx) {
            boolean lResult = false;
            XMLTag tag = (XMLTag)tagList.get(findx);
            if (tag.getName().equalsIgnoreCase(termKey)) {
                lResult = this.compareTerm(tag, depotName, streamName);
            } else {
                if (!tag.getName().equalsIgnoreCase(andKey) && !tag.getName().equalsIgnoreCase(orKey)) continue;
                lResult = this.compareCondition(tag, depotName, streamName);
            }
            if (isAndCondition) {
                boolean bl = result = result && lResult;
                if (result) continue;
                break;
            }
            boolean bl = result = result || lResult;
            if (result) break;
        }
        return result;
    }

    protected boolean compareTerm(XMLTag termTag, String depotName, String streamName) {
        boolean result = false;
        StringTokenizer tokenizer = new StringTokenizer(termTag.getContent(), " \t\"");
        tokenizer.nextToken();
        String operation = tokenizer.nextToken();
        String streamNumber = tokenizer.nextToken();
        StreamProcess wsProcess = new StreamProcess();
        List shList = wsProcess.getStreamHierarchy(depotName, streamName);
        if (operation.equalsIgnoreCase(equalsCondition)) {
            StreamData basis = (StreamData)shList.get(0);
            result = streamNumber.equalsIgnoreCase(basis.getNumber());
        } else if (operation.equalsIgnoreCase(notEqualsCondition)) {
            StreamData basis = (StreamData)shList.get(0);
            result = !streamNumber.equalsIgnoreCase(basis.getNumber());
        } else if (operation.equalsIgnoreCase(isInHierarchyCondition)) {
            result = this.withinHierarchy(streamNumber, shList);
        } else if (operation.equalsIgnoreCase(isNotInHierarchyCondition)) {
            result = !this.withinHierarchy(streamNumber, shList);
        }
        return result;
    }

    protected boolean withinHierarchy(String streamNumber, List shList) {
        boolean result = false;
        for (int findx = 0; findx < shList.size() && !result; ++findx) {
            StreamData sData = (StreamData)shList.get(findx);
            result = streamNumber.equalsIgnoreCase(sData.getNumber());
        }
        return result;
    }

    protected void checkForQueryColumns() {
        if (this.isEnabled() && this.columnNames.size() == 0) {
            FieldData fData = new FieldData();
            fData.setFieldName(issueNumberKey);
            fData.setColumnName(issueNumberKey);
            this.columnNames.add(fData);
            FieldData.getColumnLabels(this.columnNames, this.depotName);
        }
    }
}

