/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.data;

import com.accurev.common.Constants;
import java.io.File;

public class ElementStatusData {
    protected String relativePath = "";
    protected String status = "";
    protected String namedVersion = "";
    protected String virtual = "";
    protected String real = "";
    protected String elementType = "";
    protected String elementId = "";
    protected String targetLocation = "";
    protected String overlapStream = "";
    protected String parentEID = "";
    protected boolean isDirectory = false;

    public ElementStatusData() {
    }

    public ElementStatusData(String relativePath, String status, String namedVersion, String virtual, String real, String elementType, String elementId, String overlapStream, boolean isDirectory) {
        this.setRelativePath(relativePath);
        this.setStatus(status);
        this.setNamedVersion(namedVersion);
        this.setVirtual(virtual);
        this.setReal(real);
        this.setElementType(elementType);
        this.setElementId(elementId);
        this.setOverlapStream(overlapStream);
        this.isDirectory = isDirectory;
    }

    public ElementStatusData(ElementStatusData data) {
        this.relativePath = data.relativePath;
        this.status = data.status;
        this.namedVersion = data.namedVersion;
        this.virtual = data.virtual;
        this.real = data.real;
        this.elementType = data.elementType;
        this.elementId = data.elementId;
        this.overlapStream = data.overlapStream;
        this.isDirectory = data.isDirectory;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(String targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void setRelativePath(String relativePath) {
        String string = this.relativePath = relativePath == null ? "" : relativePath;
        if (this.relativePath.startsWith(Constants.TWO_CHARACTER_RELATIVE_PATH_PREFIX)) {
            this.relativePath = File.separator + this.relativePath;
        }
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setNamedVersion(String namedVersion) {
        this.namedVersion = namedVersion;
    }

    public void setVirtual(String virtual) {
        this.virtual = virtual;
    }

    public void setReal(String real) {
        this.real = real;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setOverlapStream(String overlapStream) {
        this.overlapStream = overlapStream;
    }

    public void setIsDirectory(String isDirectory) {
        this.isDirectory = isDirectory == null ? false : isDirectory.equalsIgnoreCase("yes");
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getStatus() {
        return this.status;
    }

    public String getNamedVersion() {
        return this.namedVersion;
    }

    public String getVirtual() {
        return this.virtual;
    }

    public String getReal() {
        return this.real;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getOverlapStream() {
        return this.overlapStream;
    }

    public String getParentEID() {
        return this.parentEID;
    }

    public void setParentEID(String parentEID) {
        this.parentEID = parentEID;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean hasAnyStatus() {
        return this.status.length() > 0;
    }

    public boolean isNotExists() {
        return this.status.indexOf("no such elem") >= 0;
    }

    public boolean isMember() {
        return this.status.indexOf("member") >= 0;
    }

    public boolean isBacked() {
        return this.status.indexOf("backed") >= 0;
    }

    public boolean isModified() {
        return this.status.indexOf("modified") >= 0;
    }

    public boolean isKept() {
        return this.status.indexOf("kept") >= 0;
    }

    public boolean isStale() {
        return this.status.indexOf("stale") >= 0;
    }

    public boolean isOverlap() {
        return this.status.indexOf("overlap") >= 0;
    }

    public boolean isExternal() {
        return this.status.indexOf("external") >= 0;
    }

    public boolean isMissing() {
        return this.status.indexOf("missing") >= 0;
    }

    public boolean isDefunct() {
        return this.status.indexOf("defunct") >= 0;
    }

    public boolean isTextFile() {
        return !this.isDirectory() && this.elementType.indexOf("text") >= 0;
    }

    public boolean isLinkFile() {
        return !this.isDirectory() && this.elementType.indexOf("link") >= 0;
    }

    public boolean isBinaryFile() {
        return !this.isDirectory() && this.elementType.indexOf("binary") >= 0;
    }

    public String getName() {
        return this.relativePath.substring(this.relativePath.lastIndexOf(File.separator) + 1);
    }

    public String getAbsolutePath(String wsPath) {
        String aPath = wsPath + this.relativePath.substring(2);
        return aPath.replace(File.separatorChar, '/');
    }

    public String toString() {
        return "Relative Path: " + this.relativePath + ", Status: " + this.status + ", Named Version: " + this.namedVersion + ", Virtual: " + this.virtual + ", Real: " + this.real + ", Elememt Type: " + this.elementType + ", Element Id: " + this.elementId + ", Overlap Stream: " + this.overlapStream + ", Is Directory: " + this.isDirectory;
    }

    public boolean allowAddToDepot() {
        return this.isExternal();
    }

    public boolean allowAnchor() {
        return !this.isMember() && !this.isExternal() && !this.isDirectory() && this.hasAnyStatus() && !this.isStale();
    }

    public boolean allowDefunct() {
        return !this.isDefunct() && !this.isExternal() && this.hasAnyStatus();
    }

    public boolean allowDiffBacked() {
        return !(!this.isModified() && !this.isKept() && !this.isBacked() && !this.isMember() || !this.isTextFile() && !this.isLinkFile());
    }

    public boolean allowDiffMostRecent() {
        return !(!this.isModified() && !this.isKept() && !this.isMember() && !this.isBacked() || !this.isTextFile() && !this.isLinkFile());
    }

    public boolean allowDiffBasis() {
        return !(!this.isModified() && !this.isKept() && !this.isMember() && !this.isBacked() || !this.isTextFile() && !this.isLinkFile());
    }

    public boolean allowDiffFileOnDisk() {
        return this.isExternal() || (this.isModified() || this.isKept() || this.isMember() || this.isBacked() || this.isMissing()) && (this.isTextFile() || this.isLinkFile());
    }

    public boolean allowKeep() {
        return (this.isModified() && !this.isExternal() || this.isBacked() || this.isKept() || this.isMember()) && !this.isDirectory;
    }

    public boolean allowPopulate() {
        return !this.isExternal();
    }

    public boolean allowPromote() {
        return !(!this.isKept() && !this.isModified() || this.isMember() && this.isOverlap());
    }

    public boolean allowKeepAndPromote() {
        return (this.allowKeep() || this.allowPromote()) && !this.isOverlap() && !this.isDirectory();
    }

    public boolean allowRevertToBacked() {
        return this.isMember() || this.isModified() || this.isMissing() || this.isDefunct();
    }

    public boolean allowRevertToMostRecent() {
        return !this.isExternal() && !this.isBacked() && !this.isDirectory() && !this.isLinkFile();
    }
}

