/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.data;

import com.accurev.common.Constants;
import com.accurev.common.data.UserData;
import com.accurev.common.data.XMLTag;
import com.accurev.common.process.StreamProcess;
import com.accurev.common.utils.DateTimeUtilities;
import java.util.ArrayList;
import java.util.List;

public class FieldData {
    protected String fieldName = "";
    protected String columnName = "";
    protected int width = 100;
    protected String dataType = "";
    protected String granularity = "";
    private String fid = "";
    private String label = "";
    private String reportWidth = "";
    private String listName = "";
    private String height = "";
    private String timespanUnit = "";
    private String value = "";
    private boolean prependLogMode;
    private boolean hidden;
    private boolean isLookupField = false;
    private int relationshipType;
    private List fieldValues;
    private String sortOrder = "";
    private String sortSeqNum = "";
    public static final int DEFAULT_FIELD_WIDTH = 100;
    private static final String fieldKey = "field";
    private static final String granularityKey = "granularity";
    private static final String issueNumberKey = "issueNum";
    private static final String labelKey = "label";
    private static final String nameKey = "name";
    private static final String templateKey = "template";
    private static final String typeKey = "type";
    private static final String widthKey = "width";
    private static final String USER_VALUE = "User";
    private static final String TIMESPAN_VALUE = "Timespan";
    private static final String TIMESTAMP_VALUE = "Timestamp";
    private static final String INTERNAL_VALUE = "internal";

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fName) {
        this.fieldName = fName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String cName) {
        this.columnName = cName;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width == null ? 100 : Integer.valueOf(width);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dType) {
        this.dataType = dType;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public String displayValue(String value) {
        try {
            UserData uData;
            if (TIMESPAN_VALUE.equalsIgnoreCase(this.dataType)) {
                long lValue = Long.valueOf(value);
                lValue -= lValue % 3L;
                value = Double.toString((double)lValue / 60.0);
            } else if (TIMESTAMP_VALUE.equalsIgnoreCase(this.dataType)) {
                Long lValue = Long.valueOf(value);
                value = DateTimeUtilities.accurevTimestampToDateTime(lValue);
            } else if (USER_VALUE.equalsIgnoreCase(this.dataType) && (uData = UserData.getUserDataByUserNumber(value)) != null) {
                value = uData.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    public Comparable comparisonValue(Comparable value) {
        Comparable result = value;
        try {
            if (this.dataType.equalsIgnoreCase(INTERNAL_VALUE)) {
                if (!(value instanceof Integer)) {
                    result = Constants.SMALLEST_INTEGER;
                    result = Integer.valueOf(value.toString());
                }
            } else if (this.dataType.equalsIgnoreCase(TIMESPAN_VALUE) && !(value instanceof Double)) {
                result = Constants.SMALLEST_DOUBLE;
                result = Double.valueOf(value.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static List getColumnInformation(List fieldList, String depotName) {
        ArrayList<FieldData> columnNames = new ArrayList<FieldData>();
        boolean issueNumberFound = false;
        for (int findx = 0; findx < fieldList.size(); ++findx) {
            XMLTag tag = (XMLTag)fieldList.get(findx);
            String fName = tag.getAttributeValue(nameKey);
            if (fName == null) continue;
            FieldData fData = new FieldData();
            fData.setFieldName(fName);
            fData.setColumnName(fName);
            String fWidth = tag.getAttributeValue(widthKey);
            if (fWidth != null) {
                fData.setWidth(fWidth);
            }
            if (!issueNumberFound && fName.equalsIgnoreCase(issueNumberKey)) {
                columnNames.add(0, fData);
                issueNumberFound = true;
                continue;
            }
            columnNames.add(fData);
        }
        if (!issueNumberFound) {
            FieldData fData = new FieldData();
            fData.setFieldName(issueNumberKey);
            fData.setColumnName(issueNumberKey);
            columnNames.add(0, fData);
        }
        return FieldData.getColumnLabels(columnNames, depotName);
    }

    public static List getColumnLabels(List columnNames, String depotName) {
        StreamProcess process = new StreamProcess();
        List tagList = process.runGetConfigSchema(depotName);
        if (tagList.size() < 0) {
            return columnNames;
        }
        XMLTag templateTag = (XMLTag)tagList.get(0);
        if (!templateTag.getName().equalsIgnoreCase(templateKey)) {
            return columnNames;
        }
        List fieldList = templateTag.getTags(fieldKey);
        block0: for (int cnIndex = 0; cnIndex < columnNames.size(); ++cnIndex) {
            FieldData fData = (FieldData)columnNames.get(cnIndex);
            String fieldName = fData.getFieldName();
            for (int findx = 0; findx < fieldList.size(); ++findx) {
                XMLTag fieldTag = (XMLTag)fieldList.get(findx);
                String name = fieldTag.getAttributeValue(nameKey);
                if (name == null || !fieldName.equalsIgnoreCase(name)) continue;
                fData.setColumnName(fieldTag.getAttributeValue(labelKey));
                fData.setDataType(fieldTag.getAttributeValue(typeKey));
                fData.setGranularity(fieldTag.getAttributeValue(granularityKey));
                continue block0;
            }
        }
        return columnNames;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public List getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(List fieldValues) {
        this.fieldValues = fieldValues;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public boolean isLookupField() {
        return this.isLookupField;
    }

    public void setLookupField(boolean isLookupField) {
        this.isLookupField = isLookupField;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getListName() {
        return this.listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public boolean isPrependLogMode() {
        return this.prependLogMode;
    }

    public void setPrependLogMode(boolean prependLogMode) {
        this.prependLogMode = prependLogMode;
    }

    public int getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(int relationshipType) {
        this.relationshipType = relationshipType;
    }

    public String getReportWidth() {
        return this.reportWidth;
    }

    public void setReportWidth(String reportWidth) {
        this.reportWidth = reportWidth;
    }

    public String getTimespanUnit() {
        return this.timespanUnit;
    }

    public void setTimespanUnit(String timespanUnit) {
        this.timespanUnit = timespanUnit;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortSeqNum() {
        return this.sortSeqNum;
    }

    public void setSortSeqNum(String sortSeqNum) {
        this.sortSeqNum = sortSeqNum;
    }
}

