/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.data;

import com.accurev.common.data.ChangePackageData;
import com.accurev.common.data.ClientDispatchPromoteData;
import com.accurev.common.data.FieldData;
import com.accurev.common.data.IssueData;
import com.accurev.common.data.UserData;
import com.accurev.common.utils.FileUtilities;
import java.util.ArrayList;
import java.util.List;

public class WorkspaceInformation {
    private String principalUserName = "";
    private String workspaceName = "";
    private String depotName = "";
    private String basisStreamName = "";
    private String workspaceDirectoryPath = "";
    private UserData userData = null;
    private ChangePackageData changePackageData = null;
    private ClientDispatchPromoteData clientDispatchPromoteData = null;
    private String accurevBinPath = null;
    private String serverName = "";
    private String port = "";

    public void setPrincipalUserName(String puName) {
        this.principalUserName = puName;
    }

    public void setWorkspaceName(String wsName) {
        this.workspaceName = wsName;
    }

    public void setDepotName(String dName) {
        this.depotName = dName;
    }

    public void setBasisStreamName(String bsName) {
        this.basisStreamName = bsName;
    }

    public void setWorkspaceDirectoryPath(String wdPath) {
        this.workspaceDirectoryPath = wdPath;
    }

    public void setAccuRevPath(String path) {
        this.accurevBinPath = path;
    }

    public String getPrincipalUserName() {
        return this.principalUserName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getDepotName() {
        return this.depotName;
    }

    public String getBasisStreamName() {
        return this.basisStreamName;
    }

    public String getWorkspaceDirectoryPath() {
        return this.workspaceDirectoryPath;
    }

    public String getAccurevBinPath() {
        return this.accurevBinPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean equals(Object wsiData) {
        boolean result = false;
        if (wsiData != null && wsiData.getClass() == this.getClass()) {
            result = this.workspaceName.equals(((WorkspaceInformation)wsiData).workspaceName);
        }
        return result;
    }

    public int hashCode() {
        return this.workspaceName.hashCode();
    }

    public String toString() {
        return "User Name:  " + this.principalUserName + "\nWorkspace:  " + this.workspaceName + "\nDepot:  " + this.depotName + "\nBasis Stream:  " + this.basisStreamName + "\nWorkspace Path:  " + this.workspaceDirectoryPath + "\nAccuWork integration (change packages):  " + (this.getChangePackageData().isEnabled() ? "Enabled" : "Disabled") + "\nAccuWork integration (transactions):  " + (this.getClientDispatchPromoteData().isEnabled() ? "Enabled" : "Disabled");
    }

    public UserData getUserData() {
        if (!this.isValid() || this.userData != null) {
            return this.userData;
        }
        this.userData = UserData.getUserDataByUserName(this.principalUserName);
        return this.userData;
    }

    public ChangePackageData getChangePackageData() {
        if (!this.isValid() || this.changePackageData != null) {
            return this.changePackageData;
        }
        this.changePackageData = new ChangePackageData(this.depotName, this.basisStreamName, this.getUserData());
        return this.changePackageData;
    }

    public ClientDispatchPromoteData getClientDispatchPromoteData() {
        if (!this.isValid() || this.clientDispatchPromoteData != null) {
            return this.clientDispatchPromoteData;
        }
        this.clientDispatchPromoteData = new ClientDispatchPromoteData(this.depotName, this.getUserData());
        return this.clientDispatchPromoteData;
    }

    public boolean isValid() {
        return this.workspaceName != null && this.workspaceName.length() > 0;
    }

    public boolean isIssueNumberRequired() {
        return this.getChangePackageData().isEnabled() || this.getClientDispatchPromoteData().isEnabled();
    }

    public List getColumnNames() {
        return this.getChangePackageData().isEnabled() ? this.getChangePackageData().getColumnNames() : this.getClientDispatchPromoteData().getColumnNames();
    }

    public List getIssues() {
        ArrayList listData = new ArrayList();
        if (!this.isIssueNumberRequired()) {
            return listData;
        }
        List columnList = this.getColumnNames();
        List issuesList = IssueData.getIssueData(this.getChangePackageData(), this.getClientDispatchPromoteData());
        for (int iIndex = 0; iIndex < issuesList.size(); ++iIndex) {
            IssueData issueData = (IssueData)issuesList.get(iIndex);
            ArrayList<String> rowList = new ArrayList<String>(columnList.size());
            listData.add(rowList);
            for (int cIndex = 0; cIndex < columnList.size(); ++cIndex) {
                FieldData fieldData = (FieldData)columnList.get(cIndex);
                String fieldValue = issueData.getFieldValue(fieldData.getFieldName());
                if (fieldValue == null) {
                    rowList.add("");
                    continue;
                }
                rowList.add(fieldData.displayValue(fieldValue));
            }
        }
        return listData;
    }

    public boolean pathInWorkspace(String path) {
        return FileUtilities.withinPath(this.workspaceDirectoryPath, path);
    }
}

