/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.data.StreamData;
import com.accurev.common.data.TransactionData;
import com.accurev.common.data.VersionData;
import com.accurev.common.parsers.AccuRevHandler;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HistoryParser
extends AccuRevHandler {
    private String taskID = "";
    protected StringBuffer commentData;
    protected StringBuffer issueNumber;
    protected boolean isCommentTagProcessingInProgress = false;
    protected boolean isIssueNumberProcessingInProgress = false;
    private TransactionData transData = null;
    protected Vector historyCollection = new Vector();
    protected Hashtable streamCollection = new Hashtable();
    protected static final String TRANSACTION_TAG = "transaction";
    protected static final String ACRESPONSE_TAG = "acResponse";
    protected static final String ISSUE_NUM_TAG = "issueNum";
    protected static final String TASK_ID_TAG = "TaskId";
    protected static final String ID_TAG = "id";
    protected static final String TYPE_TAG = "type";
    protected static final String TIME_TAG = "time";
    protected static final String USER_TAG = "user";
    protected static final String COMMENT_TAG = "comment";
    protected static final String VERSION_TAG = "version";
    protected static final String VIRTUAL_VERSION_TAG = "virtual";
    protected static final String REAL_VERSION_TAG = "real";
    protected static final String ANCESTOR_VERSION_TAG = "ancestor";
    protected static final String ELEMENT_TYPE_TAG = "elem_type";
    protected static final String PATH_TAG = "path";
    protected static final String STATUS_TAG = "status";
    protected static final String EID_TAG = "eid";
    protected static final String VIRTUAL_NAMED_VERSION_TAG = "virtualNamedVersion";
    protected static final String REAL_NAMED_VERSION_TAG = "realNamedVersion";
    protected static final String ANCESTOR_NAMED_VERSION_TAG = "ancestorNamedVersion";
    protected static final String MERGED_AGAINST_TAG = "merged_against";
    protected static final String PATCHED_FROM_TAG = "patched_from";
    protected static final String MERGED_AGAINST_NAMED_VERSION_TAG = "mergedAgainstNamedVersion";
    protected static final String PATCHED_FROM_NAMED_VERSION_TAG = "patchedFromNamedVersion";
    protected static final String PATCH_BASIS_STREAM_TAG = "patch_basis_stream";
    protected static final String PATCH_BASIS_VER_TAG = "patch_basis_ver";
    protected static final String REVERTED_FROM_TAG = "reverted_from";
    protected static final String REVERT_BASIS_STREAM_TAG = "revert_basis_stream";
    protected static final String REVERT_BASIS_VER_TAG = "revert_basis_ver";
    protected static final String PATCH_BASIS_NAMED_STREAM_TAG = "patchBasisNamedStream";
    protected static final String REVERTED_FROM_NAMED_VERSION_TAG = "revertedFromNamedVersion";
    protected static final String REVERT_BASIS_NAMED_STREAM_TAG = "revertBasisNamedStream";
    protected static final String DIR_TAG = "dir";
    protected static final String TARGET_NAME_TAG = "target_name";
    protected static final String TARGET_EID_TAG = "target_eid";
    protected static final String STREAM_TAG = "stream";
    protected static final String STREAM_ID_TAG = "id";
    protected static final String STREAM_NAME_TAG = "name";
    protected static final String STREAM_TYPE_TAG = "type";

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (attributes != null) {
            if (name.equalsIgnoreCase(ACRESPONSE_TAG)) {
                this.taskID = attributes.getValue(TASK_ID_TAG);
            } else if (name.equalsIgnoreCase(TRANSACTION_TAG)) {
                this.transData = new TransactionData();
                this.transData.setTranTime(attributes.getValue(TIME_TAG));
                this.transData.setTranType(attributes.getValue("type"));
                this.transData.setTranUser(attributes.getValue(USER_TAG));
                this.transData.setTranId(attributes.getValue("id"));
            } else if (name.equalsIgnoreCase(COMMENT_TAG)) {
                this.isCommentTagProcessingInProgress = true;
                this.commentData = new StringBuffer();
            } else if (name.equalsIgnoreCase(VERSION_TAG)) {
                String patchBasisStream = "";
                String patchBasisVersion = "";
                String revertBasisStream = "";
                String revertBasisVersion = "";
                VersionData versionData = new VersionData();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attributeName = attributes.getQName(i);
                    if (attributeName.equals(VIRTUAL_VERSION_TAG)) {
                        versionData.setVerVirtual(attributes.getValue(VIRTUAL_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(REAL_VERSION_TAG)) {
                        versionData.setVerReal(attributes.getValue(REAL_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(ANCESTOR_VERSION_TAG)) {
                        versionData.setVerAncestor(attributes.getValue(ANCESTOR_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(ELEMENT_TYPE_TAG)) {
                        versionData.setVerElemType(attributes.getValue(ELEMENT_TYPE_TAG));
                        continue;
                    }
                    if (attributeName.equals(PATH_TAG)) {
                        versionData.setVerPath(attributes.getValue(PATH_TAG));
                        continue;
                    }
                    if (attributeName.equals(STATUS_TAG)) {
                        versionData.setVerStatus(attributes.getValue(STATUS_TAG));
                        continue;
                    }
                    if (attributeName.equals(EID_TAG)) {
                        versionData.setVerEID(attributes.getValue(EID_TAG));
                        continue;
                    }
                    if (attributeName.equals(VIRTUAL_NAMED_VERSION_TAG)) {
                        versionData.setVerVirtualName(attributes.getValue(VIRTUAL_NAMED_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(REAL_NAMED_VERSION_TAG)) {
                        versionData.setVerRealName(attributes.getValue(REAL_NAMED_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(ANCESTOR_NAMED_VERSION_TAG)) {
                        versionData.setVerAncestorName(attributes.getValue(ANCESTOR_NAMED_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(MERGED_AGAINST_TAG)) {
                        versionData.setVerMergedAgainst(attributes.getValue(MERGED_AGAINST_TAG));
                        continue;
                    }
                    if (attributeName.equals(PATCHED_FROM_TAG)) {
                        versionData.setVerPatchedFrom(attributes.getValue(PATCHED_FROM_TAG));
                        continue;
                    }
                    if (attributeName.equals(MERGED_AGAINST_NAMED_VERSION_TAG)) {
                        versionData.setVerMergedAgainstName(attributes.getValue(MERGED_AGAINST_NAMED_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(PATCHED_FROM_NAMED_VERSION_TAG)) {
                        versionData.setVerPatchedFromName(attributes.getValue(PATCHED_FROM_NAMED_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(PATCH_BASIS_STREAM_TAG)) {
                        patchBasisStream = attributes.getValue(PATCH_BASIS_STREAM_TAG);
                        continue;
                    }
                    if (attributeName.equals(PATCH_BASIS_VER_TAG)) {
                        patchBasisVersion = attributes.getValue(PATCH_BASIS_VER_TAG);
                        continue;
                    }
                    if (attributeName.equals(REVERTED_FROM_TAG)) {
                        versionData.setVerRevertedFrom(attributes.getValue(REVERTED_FROM_TAG));
                        continue;
                    }
                    if (attributeName.equals(REVERT_BASIS_STREAM_TAG)) {
                        revertBasisStream = attributes.getValue(REVERT_BASIS_STREAM_TAG);
                        continue;
                    }
                    if (attributeName.equals(REVERT_BASIS_VER_TAG)) {
                        revertBasisVersion = attributes.getValue(REVERT_BASIS_VER_TAG);
                        continue;
                    }
                    if (attributeName.equals(PATCH_BASIS_NAMED_STREAM_TAG)) {
                        versionData.setVerPatchBasisName(attributes.getValue(PATCH_BASIS_NAMED_STREAM_TAG));
                        continue;
                    }
                    if (attributeName.equals(REVERTED_FROM_NAMED_VERSION_TAG)) {
                        versionData.setVerRevertedFromName(attributes.getValue(REVERTED_FROM_NAMED_VERSION_TAG));
                        continue;
                    }
                    if (attributeName.equals(REVERT_BASIS_NAMED_STREAM_TAG)) {
                        versionData.setVerRevertBasisName(attributes.getValue(REVERT_BASIS_NAMED_STREAM_TAG));
                        continue;
                    }
                    if (attributeName.equals(DIR_TAG)) {
                        versionData.setVerIsDir(attributes.getValue(DIR_TAG).equals("yes"));
                        continue;
                    }
                    if (attributeName.equals(TARGET_NAME_TAG)) {
                        versionData.setTargetName(attributes.getValue(TARGET_NAME_TAG));
                        continue;
                    }
                    if (!attributeName.equals(TARGET_EID_TAG)) continue;
                    versionData.setTargetEID(attributes.getValue(TARGET_EID_TAG));
                }
                if (!patchBasisStream.equals("") && !patchBasisVersion.equals("")) {
                    versionData.setVerPatchBasis(patchBasisStream + "/" + patchBasisVersion);
                }
                if (!revertBasisStream.equals("") && !revertBasisVersion.equals("")) {
                    versionData.setVerRevertBasis(revertBasisStream + "/" + revertBasisVersion);
                }
                this.transData.addVersion(versionData);
                this.transData.setFileVersion(versionData);
            } else if (name.equalsIgnoreCase(STREAM_TAG)) {
                StreamData sData = new StreamData();
                sData.setNumber(attributes.getValue("id"));
                sData.setName(attributes.getValue(STREAM_NAME_TAG));
                sData.setType(attributes.getValue("type"));
                this.streamCollection.put(sData.getNumber(), sData);
            } else if (name.equals(ISSUE_NUM_TAG)) {
                this.isIssueNumberProcessingInProgress = true;
                this.issueNumber = new StringBuffer();
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (name.equals(TRANSACTION_TAG)) {
            this.historyCollection.add(this.transData);
        }
        if (name.equalsIgnoreCase(COMMENT_TAG)) {
            this.isCommentTagProcessingInProgress = false;
            this.transData.setComment(this.commentData.toString());
        } else if (name.equals(ISSUE_NUM_TAG)) {
            this.isIssueNumberProcessingInProgress = false;
            ((VersionData)this.transData.getVersions().lastElement()).getIssueNumVector().addElement(this.issueNumber.toString());
        }
    }

    public void characters(char[] charArray, int start, int length) throws SAXException {
        super.characters(charArray, start, length);
        if (this.isCommentTagProcessingInProgress) {
            this.commentData.append(charArray, start, length);
        } else if (this.isIssueNumberProcessingInProgress) {
            this.issueNumber.append(charArray, start, length);
        }
    }

    public Vector getHistoryDataCollection() {
        return this.historyCollection;
    }

    public void convertVersionData() {
        Iterator historyIterator = this.historyCollection.iterator();
        Vector versions = null;
        Iterator versionsIterator = null;
        VersionData versionData = null;
        while (historyIterator.hasNext()) {
            TransactionData transData = (TransactionData)historyIterator.next();
            versions = transData.getVersions();
            versionsIterator = versions.iterator();
            while (versionsIterator.hasNext()) {
                versionData = (VersionData)versionsIterator.next();
                versionData.setVerVirtual(StreamData.convertStreamVersion(versionData.getVerVirtual(), this.streamCollection));
                versionData.setVerReal(StreamData.convertStreamVersion(versionData.getVerReal(), this.streamCollection));
                versionData.setVerAncestor(StreamData.convertStreamVersion(versionData.getVerAncestor(), this.streamCollection));
            }
        }
    }

    public String getTaskID() {
        return this.taskID;
    }
}

