/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.data.IssueCPKElementData;
import com.accurev.common.parsers.AccuRevHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IssueCPKParser
extends AccuRevHandler {
    private List issueCPKList = new ArrayList();

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        super.startElement(uri, localName, name, attrs);
        if (attrs != null && name.equalsIgnoreCase("element")) {
            IssueCPKElementData cpkElementData = new IssueCPKElementData();
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.getQName(i).equalsIgnoreCase("real_version")) {
                    cpkElementData.setReal(attrs.getValue(i));
                    continue;
                }
                if (attrs.getQName(i).equalsIgnoreCase("basis_version")) {
                    cpkElementData.setBasisVersion(attrs.getValue(i));
                    continue;
                }
                if (attrs.getQName(i).equalsIgnoreCase("id")) {
                    cpkElementData.setElementId(attrs.getValue(i));
                    continue;
                }
                if (attrs.getQName(i).equalsIgnoreCase("missing")) {
                    cpkElementData.setMissing(attrs.getValue(i).equals("true"));
                    continue;
                }
                if (attrs.getQName(i).equalsIgnoreCase("elemType")) {
                    cpkElementData.setElementType(attrs.getValue(i));
                    continue;
                }
                if (attrs.getQName(i).equalsIgnoreCase("dir")) {
                    cpkElementData.setIsDirectory(attrs.getValue(i));
                    continue;
                }
                if (attrs.getQName(i).equalsIgnoreCase("targetLocation")) {
                    cpkElementData.setTargetLocation(attrs.getValue(i));
                    continue;
                }
                if (!attrs.getQName(i).equalsIgnoreCase("location")) continue;
                cpkElementData.setRelativePath(attrs.getValue(i).replace('/', File.separatorChar));
            }
            this.issueCPKList.add(cpkElementData);
        }
    }

    public List getIssueCPK() {
        return this.issueCPKList;
    }
}

