/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.parsers.AccuRevHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IssueParser
extends AccuRevHandler {
    private Map issue = new HashMap();
    private List issues = new ArrayList();
    private Map issuesMap = new HashMap();
    private Vector relationshipIssues = new Vector(2);
    private String taskID;
    private boolean parentsParsing = false;
    private boolean childrenParsing = false;
    private boolean issueConflict = false;
    private String attachment;
    private Vector attachments;
    private StringBuffer value = new StringBuffer();
    private int issuesProcessed = 0;
    public static final String ANCESTRY_KEY = "(ancestry)";

    public void startDocument() throws SAXException {
        super.startDocument();
        this.relationshipIssues.add(new Vector());
        this.relationshipIssues.add(new Vector());
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        super.startElement(uri, localName, name, attrs);
        if (attrs != null) {
            if (name.equalsIgnoreCase("acResponse")) {
                this.taskID = attrs.getValue("TaskId");
            } else if (name.equalsIgnoreCase("issues")) {
                this.issuesMap = new HashMap();
                this.issues = new ArrayList();
                this.issuesProcessed = 0;
                if (attrs.getValue("relationship") != null && attrs.getValue("relationship").equals("parent")) {
                    this.parentsParsing = false;
                    this.childrenParsing = true;
                } else if (attrs.getValue("relationship") != null && attrs.getValue("relationship").equals("child")) {
                    this.parentsParsing = true;
                    this.childrenParsing = false;
                }
            } else if (name.equalsIgnoreCase("issue")) {
                this.issue = new HashMap();
                if (attrs.getValue("ancestry") != null) {
                    this.issue.put(ANCESTRY_KEY, attrs.getValue("ancestry"));
                }
            } else if (name.equalsIgnoreCase("attachment") && attrs.getValue("fid") == null) {
                if (this.attachments == null) {
                    this.attachments = new Vector();
                }
                this.attachment = null;
            } else {
                this.value = name.equalsIgnoreCase("storageId") && this.attachment != null ? new StringBuffer() : (name.equalsIgnoreCase("name") && this.attachment != null ? new StringBuffer() : (name.equalsIgnoreCase("userNum") && this.attachment != null ? new StringBuffer() : (name.equalsIgnoreCase("date") && this.attachment != null ? new StringBuffer() : (name.equalsIgnoreCase("fileSize") && this.attachment != null ? new StringBuffer() : (name.equalsIgnoreCase("originalFileName") && this.attachment != null ? new StringBuffer() : (name.equalsIgnoreCase("comment") && this.attachment != null ? new StringBuffer() : new StringBuffer()))))));
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (!name.equalsIgnoreCase("acResponse")) {
            if (name.equalsIgnoreCase("issues")) {
                if (this.parentsParsing) {
                    this.relationshipIssues.set(0, this.issues);
                } else if (this.childrenParsing) {
                    this.relationshipIssues.set(1, this.issues);
                }
                this.parentsParsing = false;
                this.childrenParsing = false;
            } else if (name.equalsIgnoreCase("issue")) {
                this.issuesMap.put(this.issue.get("issueNum"), this.issue);
                this.issues.add(this.issue);
                ++this.issuesProcessed;
            } else if (this.attachments != null) {
                this.issue.put(name, this.attachments);
                this.attachments = null;
            } else {
                this.issue.put(name, this.value.toString());
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.value.append(ch, start, length);
    }

    public List getIssues() {
        return this.issues;
    }

    public Map getIssuesMap() {
        return this.issuesMap;
    }

    public Vector getRelationshipIssues() {
        return this.relationshipIssues;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public boolean getIssueConflict() {
        return this.issueConflict;
    }
}

