/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.data.FieldData;
import com.accurev.common.parsers.AccuRevHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaParser
extends AccuRevHandler {
    private String value;
    private List fieldValues = new ArrayList();
    private Map fieldMap = new HashMap();
    private FieldData data;
    private String defaultLookup = null;
    private String lookup = null;

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        super.startElement(uri, localName, name, attrs);
        if (attrs != null) {
            if (name.equals("value")) {
                this.value = "";
            } else if (name.equals("lookupField")) {
                this.lookup = attrs.getValue("fid");
            } else if (name.equals("field")) {
                this.data = new FieldData();
                this.data.setFieldName(attrs.getValue("name"));
                this.data.setDataType(attrs.getValue("type"));
                this.data.setFid(attrs.getValue("fid"));
                if (this.data.getFieldName().equals("issueNum")) {
                    this.defaultLookup = attrs.getValue("fid");
                }
                this.data.setLabel(attrs.getValue("label"));
                this.data.setReportWidth(attrs.getValue("reportWidth"));
                this.data.setGranularity(attrs.getValue("granularity") == null ? "second" : attrs.getValue("granularity"));
                this.data.setTimespanUnit(attrs.getValue("timespanUnit"));
                this.data.setPrependLogMode(attrs.getValue("prependLogMode") == null || attrs.getValue("prependLogMode").equals("true"));
                this.data.setListName(attrs.getValue("listName"));
                if (attrs.getValue("relationshipType") != null) {
                    this.data.setRelationshipType(Integer.parseInt(attrs.getValue("relationshipType")));
                }
                this.data.setHeight(attrs.getValue("height") == null ? "" : attrs.getValue("height"));
                this.data.setWidth(attrs.getValue("width"));
                this.data.setHidden(attrs.getValue("isHidden") == null ? false : Boolean.valueOf(attrs.getValue("isHidden")));
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (name.equals("value")) {
            this.fieldValues.add(this.value);
        } else if (name.equals("template")) {
            if (this.lookup == null) {
                this.lookup = this.defaultLookup;
            }
            Iterator it = this.fieldMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FieldData fieldData = (FieldData)entry.getValue();
                if (!fieldData.getFid().equals(this.lookup)) continue;
                fieldData.setLookupField(true);
                break;
            }
        } else if (name.equals("field")) {
            this.data.setFieldValues(this.fieldValues);
            this.fieldMap.put(this.data.getFieldName(), this.data);
            this.data = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.value = this.value + new String(ch, start, length);
    }

    public Map getSchemaFields() {
        return this.fieldMap;
    }
}

