/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.data.ElementStatusData;
import com.accurev.common.parsers.AccuRevHandler;
import com.accurev.common.process.thread.ProcessStatusListener;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StatusParser
extends AccuRevHandler {
    protected Vector elementStatusCollection = new Vector();
    protected Class containerClass = class$com$accurev$common$data$ElementStatusData == null ? (class$com$accurev$common$data$ElementStatusData = StatusParser.class$("com.accurev.common.data.ElementStatusData")) : class$com$accurev$common$data$ElementStatusData;
    protected static final String ELEMENT_NAME = "Element";
    protected static final String LOCATION_TAG = "location";
    protected static final String STATUS_TAG = "status";
    protected static final String IS_DIRECTORY_TAG = "dir";
    protected static final String NAMED_VERSION_TAG = "namedVersion";
    protected static final String VIRTUAL_VERSION_TAG = "Virtual";
    protected static final String REAL_VERSION_TAG = "Real";
    protected static final String ELEMENT_TYPE_TAG = "elemType";
    protected static final String ELEMENT_ID_TAG = "id";
    protected static final String OVERLAP_STREAM_TAG = "overlapStream";
    protected static final String TARGET_LOCATION_TAG = "targetLocation";
    protected static final String PARENT_EID_TAG = "parentEid";
    private ProcessStatusListener progressListener = null;
    static /* synthetic */ Class class$com$accurev$common$data$ElementStatusData;

    protected StatusParser() {
    }

    public StatusParser(Class containerClass, ProcessStatusListener listener) {
        this(containerClass);
        this.progressListener = listener;
    }

    public StatusParser(Class containerClass) {
        this.containerClass = containerClass;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (attributes != null && name.equalsIgnoreCase(ELEMENT_NAME)) {
            ElementStatusData esData = this.getStatusContainer();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equalsIgnoreCase(LOCATION_TAG)) {
                    esData.setRelativePath(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(STATUS_TAG)) {
                    esData.setStatus(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(IS_DIRECTORY_TAG)) {
                    esData.setIsDirectory(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(NAMED_VERSION_TAG)) {
                    esData.setNamedVersion(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(VIRTUAL_VERSION_TAG)) {
                    esData.setVirtual(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(REAL_VERSION_TAG)) {
                    esData.setReal(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(ELEMENT_TYPE_TAG)) {
                    esData.setElementType(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(ELEMENT_ID_TAG)) {
                    esData.setElementId(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(OVERLAP_STREAM_TAG)) {
                    esData.setOverlapStream(attributes.getValue(i));
                    continue;
                }
                if (attributes.getQName(i).equalsIgnoreCase(TARGET_LOCATION_TAG)) {
                    esData.setTargetLocation(attributes.getValue(i));
                    continue;
                }
                if (!attributes.getQName(i).equalsIgnoreCase(PARENT_EID_TAG)) continue;
                esData.setParentEID(attributes.getValue(i));
            }
            this.elementStatusCollection.add(esData);
            if (this.progressListener != null) {
                this.progressListener.notifyProgressUpdate(1.0);
                this.progressListener.notifyElementProcessed(esData.getRelativePath());
            }
        }
    }

    public Vector getElementStatusCollection() {
        return this.elementStatusCollection;
    }

    protected ElementStatusData getStatusContainer() {
        ElementStatusData esData = null;
        try {
            esData = (ElementStatusData)this.containerClass.newInstance();
        }
        catch (Exception e) {
            esData = new ElementStatusData();
        }
        return esData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

