/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.parsers.AccuRevHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TaskListParser
extends AccuRevHandler {
    private List taskList = new ArrayList();
    private List task;
    private String taskID;
    private String taskName;
    private String onReplica;
    private String user;
    private String host;
    private String status;
    private String startTime;
    private String secondsOnServer;
    private String taskProgressName = "";
    private String taskProgressValue = "0";
    private String taskProgressMaximum = "0";
    private String phaseProgressValue = "0";
    private String phaseProgressMaximum = "0";
    private String value;
    private String parseTaskID;

    public TaskListParser() {
    }

    public TaskListParser(String parseTaskID) {
        this.parseTaskID = parseTaskID;
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        super.startElement(uri, localName, name, attrs);
        if (attrs != null) {
            if (name.equalsIgnoreCase("task")) {
                this.task = new ArrayList(7);
                this.taskID = "";
                this.taskName = "";
                this.user = "";
                this.host = "";
                this.status = "";
                this.startTime = "";
                this.secondsOnServer = "";
                this.onReplica = "";
            } else if (name.equals("progress_counter") && this.parseTaskID != null && this.parseTaskID.equals(this.taskID) && !this.onReplica.equals("true")) {
                String counter = attrs.getValue("counter");
                if (counter.equals("0")) {
                    this.taskProgressValue = attrs.getValue("count");
                    this.taskProgressMaximum = attrs.getValue("max_count");
                } else if (counter.equals("1")) {
                    this.phaseProgressValue = attrs.getValue("count");
                    this.phaseProgressMaximum = attrs.getValue("max_count");
                }
                this.taskProgressName = this.taskName;
            } else {
                this.value = "";
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equalsIgnoreCase("task_id")) {
            this.taskID = this.value;
        } else if (name.equalsIgnoreCase("task_name")) {
            this.taskName = this.value;
        } else if (name.equalsIgnoreCase("user")) {
            this.user = this.value;
        } else if (name.equalsIgnoreCase("host")) {
            this.host = this.value;
        } else if (name.equalsIgnoreCase("status")) {
            this.status = this.value;
        } else if (name.equalsIgnoreCase("starttime")) {
            this.startTime = this.value;
        } else if (name.equalsIgnoreCase("seconds_on_server")) {
            this.secondsOnServer = this.value;
        } else if (name.equalsIgnoreCase("on_replica")) {
            this.onReplica = this.value;
        } else if (name.equalsIgnoreCase("task")) {
            this.task.add(this.taskID);
            this.task.add(this.taskName);
            this.task.add(this.user);
            this.task.add(this.host);
            this.task.add(this.status);
            this.task.add(this.startTime);
            this.task.add(this.secondsOnServer);
            this.taskList.add(this.task);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.value = this.value + new String(ch, start, length);
    }

    public List getTaskList() {
        return this.taskList;
    }

    public List getTaskProgress() {
        if (this.taskProgressMaximum.equals("0") && this.phaseProgressMaximum.equals("0")) {
            return null;
        }
        ArrayList<String> taskProgress = new ArrayList<String>(5);
        taskProgress.add(this.taskProgressValue);
        taskProgress.add(this.taskProgressMaximum);
        taskProgress.add(this.phaseProgressValue);
        taskProgress.add(this.phaseProgressMaximum);
        taskProgress.add(this.taskProgressName);
        return taskProgress;
    }
}

