/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.data.WorkspaceInformation;
import com.accurev.common.process.RunProcess;
import com.accurev.common.process.StreamProcess;
import com.accurev.common.utils.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

public class MergeProcess
extends RunProcess {
    public int merge(String pathName, String firstContri, String secondContri, String ancFile, String filePath, String backingStream) {
        String[] commandArray = new String[]{diffExecutable, "-M", pathName, secondContri, ancFile, firstContri, "--title1", "Backed Version", "--title2", firstContri};
        int status = this.exec(commandArray, filePath, true);
        File merged = new File(pathName);
        if (status == 0 && merged.exists()) {
            File old = new File(firstContri);
            FileUtilities.copyFile(merged, old);
            String[] mergeArray = new String[]{accurevExecutable, "merge", "-O", "-v", backingStream, old.getName()};
            status = this.exec(mergeArray, filePath);
        }
        if (merged.exists()) {
            merged.delete();
        }
        return status;
    }

    public String ancFile(String fileName, String fileDirectory) {
        String ancPath = null;
        File ancFile = null;
        try {
            ancFile = File.createTempFile("anc", null);
            ancFile.deleteOnExit();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] commandArray = new String[]{RunProcess.accurevExecutable, "guimerge", ancFile.getAbsolutePath(), fileName};
        if (this.exec(commandArray, fileDirectory) == 0) {
            ancPath = ancFile.getAbsolutePath();
        }
        return ancPath;
    }

    public String getAncVersion(String depotName, String wspaceDir, String streamName, String fileName, String versionOption) {
        String ver = "";
        String[] cmds1 = new String[]{accurevExecutable, "anc", "-p", depotName, "-L", wspaceDir, "-v", streamName, versionOption, fileName};
        String[] cmds2 = new String[]{accurevExecutable, "anc", "-p", depotName, "-v", streamName, versionOption, fileName};
        if (this.exec(wspaceDir == null ? cmds2 : cmds1, wspaceDir == null ? null : wspaceDir) == 0 && (ver = this.getResponseText().toString()).indexOf("\n") != ver.lastIndexOf("\n")) {
            ver = ver.substring(ver.indexOf("\n") + 1);
            ver = ver.substring(0, ver.indexOf("\n"));
        }
        return ver.trim();
    }

    public String getCommonAnc(String wsDir, String fileName) {
        String anc = "";
        String[] commandArray = new String[]{accurevExecutable, "anc", "-c", fileName};
        if (this.exec(commandArray, wsDir) == 0 && (anc = this.responseText.toString()).indexOf("\n") != anc.lastIndexOf("\n")) {
            anc = anc.substring(anc.indexOf("\n") + 1);
            anc = anc.substring(0, anc.indexOf("\n"));
        }
        return anc.trim();
    }

    public int mergeFiles(String executionDirectory, String fileName) {
        String[] commandArray1 = new String[]{accurevExecutable, "merge", "-G", "-o", "-K", fileName};
        String[] commandArray2 = new String[]{accurevExecutable, "merge", "-G", "-o", "-K"};
        return this.exec(fileName == null ? commandArray2 : commandArray1, executionDirectory, true);
    }

    public int autoMergeFile(String executionDirectory, String fileName) {
        String[] commandArray1 = new String[]{accurevExecutable, "merge", "-o", "-K", fileName};
        String[] commandArray2 = new String[]{accurevExecutable, "merge", "-o", "-K"};
        return this.exec(fileName == null ? commandArray2 : commandArray1, executionDirectory, true);
    }

    public int keepExternallyMergedFile(String fileName, String fileDirectory) {
        StreamProcess process = new StreamProcess();
        WorkspaceInformation info = process.runInfo(fileDirectory);
        String basisStreamName = info.getBasisStreamName();
        String[] commandArray = new String[]{accurevExecutable, "merge", "-O", "-v", basisStreamName, "-L", fileDirectory, fileName};
        return this.exec(commandArray, fileDirectory, true);
    }

    public int mergeFile(String wspaceDir, String streamSV, String mergeConfigFilePath) {
        Vector<String> cmds = new Vector<String>();
        cmds.add(accurevExecutable);
        cmds.add("merge");
        cmds.add("-Fx");
        cmds.add("-L");
        cmds.add(wspaceDir);
        cmds.add("-O");
        cmds.add("-v");
        cmds.add(streamSV);
        cmds.add("-l");
        cmds.add(mergeConfigFilePath);
        return this.exec(cmds.toArray(new String[0]), wspaceDir);
    }

    public int showAccuRevMerge(String mergeResultFilePath, String firstContri, String secondContri, String ancFile, String title1, String title2, String title3) {
        String[] commandArray = new String[]{diffExecutable, "-M", mergeResultFilePath, secondContri, ancFile, firstContri, "--title1", title1, "--title2", title2, "--title3", title3};
        return this.exec(commandArray, null, true);
    }
}

