/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.Constants;
import com.accurev.common.MessageHandler;
import com.accurev.common.data.SessionToken;
import com.accurev.common.parsers.AccuRevHandler;
import com.accurev.common.process.TaskProcess;
import com.accurev.common.utils.SecurityUtils;
import com.accurev.common.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RunProcess {
    protected SessionToken sessionToken;
    protected InputStreamReaderThread inputThread;
    protected BufferedInputStream input;
    protected BufferedOutputStream output;
    protected InputStreamReaderThread errorThread;
    protected BufferedInputStream error;
    protected StringBuffer responseText;
    protected StringBuffer errorText;
    protected int commandStatus = 0;
    protected Process runProcess;
    protected Runtime runRuntime = Runtime.getRuntime();
    protected AccuRevHandler parseHandler = null;
    protected boolean isEmpty = false;
    protected boolean enableDebug = false;
    protected static String accurevExecutable;
    protected static String diffExecutable;
    protected static String diffToolExecutable;
    protected static String logFilePath;
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_FAILURE = -1;
    public static final int ERR_COMMAND_NOT_EXECUTED = -2;
    public static final int ERR_PROCESS_RUN = -100001;
    public static final int ERR_PROCESS_WAIT_TERMINATED = -100002;
    public static final int ERR_PROCESS_HAS_NO_OUTPUT = -100003;
    public static final int ERR_PROCESS_NON_SPECIFIC = -100004;
    public static final int ERR_NOT_AUTHENTICATED = -100005;
    public static final int ERR_CONNECTING_SERVER = -100006;
    protected static final String SERVER_CONNECTION_FAILED = "network error";
    protected static final String ACCUREV_EXECUTABLE_WINDOWS = "accurev.exe";
    protected static final String ACCUREV_EXECUTABLE_UNIX = "accurev";
    protected static final String DIFF_TOOL_EXECUTABLE_WINDOWS = "diffw.exe";
    protected static final String DIFF_TOOL_EXECUTABLE_UNIX = "acdiff";
    protected static final String ACCUREV_DIFF_EXECUTABLE_WINDOWS = "acdiffgui.exe";
    protected static final String ACCUREV_DIFF_EXECUTABLE_UNIX = "acdiffgui";
    static /* synthetic */ Class class$com$accurev$common$process$RunProcess;

    public RunProcess() {
        this.responseText = new StringBuffer();
        this.errorText = new StringBuffer();
    }

    public BufferedInputStream getInputStream() {
        return this.input;
    }

    public BufferedInputStream getErrorStream() {
        return this.error;
    }

    public BufferedOutputStream getOutputStream() {
        return this.output;
    }

    public StringBuffer getResponseText() {
        return this.responseText;
    }

    public StringBuffer getErrorText() {
        return this.errorText;
    }

    public int getCommandStatus() {
        return this.commandStatus;
    }

    protected synchronized void printToLogFile(String text) {
        if (logFilePath != null && !logFilePath.equals("")) {
            File logFile = new File(logFilePath);
            try {
                PrintStream out = new PrintStream(new FileOutputStream(logFile, true));
                out.println(new Date() + " - " + this.sessionToken.getServer() + "/" + this.sessionToken.getUserID());
                out.println(text);
                out.flush();
                out.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    protected int exec(String[] cmdArray, String workDir) {
        return this.exec(cmdArray, workDir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int exec(String[] cmdArray, String workDir, boolean silent) {
        this.commandStatus = 0;
        cmdArray = this.addSecurityArgsToCommand(cmdArray);
        this.responseText = new StringBuffer();
        this.errorText = new StringBuffer();
        if (this.enableDebug) {
            System.out.println("ACAPI: " + this.joinStringArray(cmdArray));
        }
        this.printToLogFile(this.joinStringArray(cmdArray));
        try {
            File workDirFile = workDir == null ? null : new File(workDir);
            this.runProcess = this.runRuntime.exec(cmdArray, null, workDirFile);
            this.input = new BufferedInputStream(this.runProcess.getInputStream());
            this.output = new BufferedOutputStream(this.runProcess.getOutputStream());
            this.error = new BufferedInputStream(this.runProcess.getErrorStream());
            this.inputThread = new InputStreamReaderThread(this.input, this.responseText);
            this.errorThread = new InputStreamReaderThread(this.error, this.errorText);
            this.inputThread.start();
            this.errorThread.start();
            this.runProcess.waitFor();
            this.commandStatus = this.runProcess.exitValue();
            this.inputThread.join();
            this.errorThread.join();
            if (this.commandStatus != 0) {
                String errorMessageText = this.responseText.toString() + this.errorText.toString();
                if (!SecurityUtils.isUserAuthenticated(errorMessageText)) {
                    this.commandStatus = -100005;
                } else if (errorMessageText.length() > 0) {
                    if (errorMessageText.indexOf(SERVER_CONNECTION_FAILED) != -1) {
                        this.commandStatus = -100006;
                    }
                    if (!silent) {
                        MessageHandler.showErrorMessage(errorMessageText);
                    }
                }
            }
        }
        catch (IOException e) {
            this.commandStatus = -100001;
            MessageHandler.showErrorMessage("Error creating process.\nPlugin can't find executable path.");
        }
        catch (InterruptedException e) {
            this.commandStatus = -100002;
        }
        finally {
            this.closeProcess();
        }
        return this.commandStatus;
    }

    protected int execNoWait(String[] cmdArray, String workDir) {
        this.commandStatus = 0;
        cmdArray = this.addSecurityArgsToCommand(cmdArray);
        this.responseText = new StringBuffer();
        this.errorText = new StringBuffer();
        try {
            if (this.enableDebug) {
                System.out.println("ACAPI: " + this.joinStringArray(cmdArray));
            }
            this.printToLogFile(this.joinStringArray(cmdArray));
            File workDirFile = workDir == null ? null : new File(workDir);
            this.runProcess = this.runRuntime.exec(cmdArray, null, workDirFile);
            this.input = new BufferedInputStream(this.runProcess.getInputStream());
            this.output = new BufferedOutputStream(this.runProcess.getOutputStream());
            this.error = new BufferedInputStream(this.runProcess.getErrorStream());
        }
        catch (IOException e) {
            this.commandStatus = -100001;
            MessageHandler.showErrorMessage("Error creating process.\nPlugin can't find executable path.");
        }
        catch (Exception e) {
            this.commandStatus = -100004;
        }
        return this.commandStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int exec(String[] cmdArray, String workDir, AccuRevHandler parseHandler) {
        this.commandStatus = 0;
        cmdArray = this.addSecurityArgsToCommand(cmdArray);
        this.responseText = new StringBuffer();
        this.errorText = new StringBuffer();
        this.parseHandler = parseHandler;
        if (this.enableDebug) {
            System.out.println("ACAPI: " + this.joinStringArray(cmdArray));
        }
        this.printToLogFile(this.joinStringArray(cmdArray));
        try {
            File workDirFile = workDir == null ? null : new File(workDir);
            this.runProcess = this.runRuntime.exec(cmdArray, null, workDirFile);
            this.input = new BufferedInputStream(this.runProcess.getInputStream());
            this.output = new BufferedOutputStream(this.runProcess.getOutputStream());
            this.error = new BufferedInputStream(this.runProcess.getErrorStream());
            this.inputThread = new InputStreamReaderThread(this.input, this.responseText);
            this.errorThread = new InputStreamReaderThread(this.error, this.errorText);
            this.inputThread.start();
            this.errorThread.start();
            this.runProcess.waitFor();
            this.commandStatus = this.runProcess.exitValue();
            this.inputThread.join();
            this.errorThread.join();
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            String responseStr = this.responseText.toString();
            if (responseStr.length() > 0) {
                StringReader reader = new StringReader(responseStr);
                parser.parse(new InputSource(reader), (DefaultHandler)parseHandler);
            }
            if (this.commandStatus != 0) {
                String errorMessageText = this.errorText.toString();
                if (!SecurityUtils.isUserAuthenticated(errorMessageText)) {
                    this.commandStatus = -100005;
                } else {
                    if (parseHandler != null && parseHandler.getMessageData() != null) {
                        errorMessageText = errorMessageText + parseHandler.getMessageData();
                    }
                    if (errorMessageText.length() > 0) {
                        if (errorMessageText.indexOf(SERVER_CONNECTION_FAILED) != -1) {
                            this.commandStatus = -100006;
                        }
                        MessageHandler.showErrorMessage(errorMessageText);
                    }
                }
            }
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            MessageHandler.showErrorMessage("Error creating process.\nPlugin can't find executable path.");
            this.commandStatus = -100001;
        }
        catch (InterruptedException e) {
            this.commandStatus = -100002;
        }
        catch (Exception e) {
            this.commandStatus = -100004;
        }
        finally {
            this.closeProcess();
        }
        return this.commandStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int execWithAsyncParsing(String[] cmdArray, String workDir, AccuRevHandler parseHandler) {
        int retValue = 0;
        this.parseHandler = parseHandler;
        cmdArray = this.addSecurityArgsToCommand(cmdArray);
        this.responseText = new StringBuffer();
        this.errorText = new StringBuffer();
        this.printToLogFile(this.joinStringArray(cmdArray));
        try {
            File workDirFile = workDir == null ? null : new File(workDir);
            this.runProcess = this.runRuntime.exec(cmdArray, null, workDirFile);
            this.input = new BufferedInputStream(this.runProcess.getInputStream());
            this.output = new BufferedOutputStream(this.runProcess.getOutputStream());
            this.error = new BufferedInputStream(this.runProcess.getErrorStream());
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            InputStreamReaderThread errorThread = new InputStreamReaderThread(this.error, this.errorText);
            errorThread.start();
            this.input.mark(5);
            if (this.input.read() != -1) {
                this.input.reset();
                parser.parse(new InputSource(this.input), (DefaultHandler)parseHandler);
            }
            this.runProcess.waitFor();
            retValue = this.runProcess.exitValue();
            if (retValue != 0) {
                String errorMessageText = this.errorText.toString();
                if (!SecurityUtils.isUserAuthenticated(errorMessageText)) {
                    this.commandStatus = -100005;
                    MessageHandler.showErrorMessage(errorMessageText);
                } else {
                    if (parseHandler != null && parseHandler.getMessageData() != null) {
                        errorMessageText = errorMessageText + parseHandler.getMessageData();
                    }
                    if (errorMessageText.length() > 0 && errorMessageText.indexOf(SERVER_CONNECTION_FAILED) != -1) {
                        this.commandStatus = -100006;
                        MessageHandler.showErrorMessage(errorMessageText);
                    }
                }
            }
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            retValue = -100001;
        }
        catch (Exception e) {
            e.printStackTrace();
            retValue = -100004;
        }
        finally {
            this.closeProcess();
        }
        return this.commandStatus;
    }

    public synchronized int execWithProgress(String[] cmdArray, AccuRevHandler parseHandler) {
        int retValue = 0;
        this.parseHandler = parseHandler;
        try {
            boolean needToExecute = true;
            while (needToExecute) {
                this.runProcess = this.runRuntime.exec(cmdArray);
                this.input = new BufferedInputStream(this.runProcess.getInputStream());
                this.output = new BufferedOutputStream(this.runProcess.getOutputStream());
                this.error = new BufferedInputStream(this.runProcess.getErrorStream());
                needToExecute = false;
                Thread.currentThread().setContextClassLoader((class$com$accurev$common$process$RunProcess == null ? RunProcess.class$("com.accurev.common.process.RunProcess") : class$com$accurev$common$process$RunProcess).getClassLoader());
                XMLReader parser = XMLReaderFactory.createXMLReader();
                parser.setContentHandler(parseHandler);
                parser.setErrorHandler(parseHandler);
                StringBuffer errorString = new StringBuffer();
                ErrorReaderThread errorThread = new ErrorReaderThread(errorString);
                errorThread.start();
                this.input.mark(5);
                if (this.input.read() != -1) {
                    this.input.reset();
                    parser.parse(new InputSource(this.input));
                }
                this.runProcess.waitFor();
                retValue = this.runProcess.exitValue();
                if (retValue != 0) {
                    String errorMessageText = this.errorText.toString();
                    if (!SecurityUtils.isUserAuthenticated(errorMessageText)) {
                        this.commandStatus = -100005;
                        MessageHandler.showErrorMessage(errorMessageText);
                    } else {
                        if (parseHandler != null && parseHandler.getMessageData() != null) {
                            errorMessageText = errorMessageText + parseHandler.getMessageData();
                        }
                        if (errorMessageText.length() > 0 && errorMessageText.indexOf(SERVER_CONNECTION_FAILED) != -1) {
                            this.commandStatus = -100006;
                            MessageHandler.showErrorMessage(errorMessageText);
                        }
                    }
                }
                this.runProcess = null;
                this.input.close();
                this.output.close();
                this.error.close();
            }
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            retValue = -100001;
        }
        catch (Exception e) {
            retValue = -100004;
        }
        return retValue;
    }

    public boolean isCommandComplete() {
        boolean status = true;
        if (this.runProcess == null) {
            return status;
        }
        try {
            this.runProcess.exitValue();
        }
        catch (Exception e) {
            status = false;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroyProcess() {
        try {
            this.runProcess.destroy();
            this.runProcess.waitFor();
            this.inputThread.join();
            this.errorThread.join();
        }
        catch (InterruptedException e) {
        }
        catch (Exception exception) {
        }
        finally {
            this.closeProcess();
        }
        return -100002;
    }

    protected void closeProcess() {
        this.runProcess = null;
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.input = null;
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.output = null;
        }
        if (this.error != null) {
            try {
                this.error.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.error = null;
        }
    }

    protected int interruptParsing() {
        this.parseHandler.interrupt();
        return this.destroyProcess();
    }

    public int interruptParsing(String taskID) {
        this.parseHandler.interrupt();
        if (taskID != null && !taskID.equals("")) {
            new TaskProcess().killTask(taskID);
        }
        return this.destroyProcess();
    }

    protected String joinStringArray(String[] cArray) {
        StringBuffer buffer = new StringBuffer();
        for (int findx = 0; findx < cArray.length; ++findx) {
            buffer.append("'");
            buffer.append(cArray[findx]);
            buffer.append("' ");
        }
        return buffer.toString().trim();
    }

    public static String getAccuRevExecutable() {
        return accurevExecutable;
    }

    public static void setAccuRevExecutable(String executable) {
        accurevExecutable = executable == null || executable.trim().length() == 0 ? RunProcess.getDefaultAccuRevExecutable() : executable.trim();
    }

    public static String getDefaultAccuRevExecutable() {
        String executable = ACCUREV_EXECUTABLE_UNIX;
        if (Constants.IS_WINDOWS_OS) {
            executable = ACCUREV_EXECUTABLE_WINDOWS;
        }
        return executable;
    }

    public static int checkAccuRevExecutable(String executable) {
        String response;
        RunProcess process = new RunProcess();
        String[] commandArray = new String[]{executable};
        int status = process.exec(commandArray, null, true);
        if (status == 0 && !(response = process.getResponseText().toString()).startsWith("AccuRev")) {
            status = -1;
        }
        return status;
    }

    public static String getDiffExecutable() {
        return diffExecutable;
    }

    public static void setDiffExecutable(String executable) {
        diffExecutable = executable == null || executable.trim().length() == 0 ? RunProcess.getDefaultDiffExecutable() : executable.trim();
    }

    public static String getDefaultDiffExecutable() {
        String executable = ACCUREV_DIFF_EXECUTABLE_UNIX;
        if (Constants.IS_WINDOWS_OS) {
            executable = ACCUREV_DIFF_EXECUTABLE_WINDOWS;
        }
        return executable;
    }

    public void setSessionToken(SessionToken sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String[] addSecurityArgsToCommand(String[] cmdArray) {
        if (!cmdArray[0].equals(accurevExecutable)) {
            return cmdArray;
        }
        if (this.sessionToken != null) {
            ArrayList<String> cmdVector = new ArrayList<String>();
            cmdVector.add(cmdArray[0]);
            cmdVector.add(cmdArray[1]);
            cmdVector.add("-H");
            cmdVector.add(this.sessionToken.getServer());
            if (!this.sessionToken.getSecurityToken().equals("")) {
                cmdVector.add("-A");
                cmdVector.add(this.sessionToken.getSecurityToken());
            } else if (cmdArray[1].equals("login")) {
                cmdVector.add("-A");
            }
            for (int i = 2; i < cmdArray.length; ++i) {
                cmdVector.add(cmdArray[i]);
            }
            cmdArray = cmdVector.toArray(new String[0]);
        }
        return cmdArray;
    }

    public static String getLogFilePath() {
        return logFilePath;
    }

    public static void setLogFilePath(String filePath) {
        logFilePath = filePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringUtilities.replaceInvalidCharacters(null);
        if (Constants.IS_WINDOWS_OS) {
            accurevExecutable = ACCUREV_EXECUTABLE_WINDOWS;
            diffExecutable = ACCUREV_DIFF_EXECUTABLE_WINDOWS;
            diffToolExecutable = DIFF_TOOL_EXECUTABLE_WINDOWS;
        } else {
            accurevExecutable = ACCUREV_EXECUTABLE_UNIX;
            diffExecutable = ACCUREV_DIFF_EXECUTABLE_UNIX;
            diffToolExecutable = DIFF_TOOL_EXECUTABLE_UNIX;
        }
    }

    protected class InputStreamReaderThread
    extends Thread {
        private BufferedInputStream inputStream;
        private StringBuffer textBuffer;

        public InputStreamReaderThread(BufferedInputStream inputStream, StringBuffer textBuffer) {
            this.inputStream = inputStream;
            this.textBuffer = textBuffer;
        }

        public void run() {
            try {
                String inputLine;
                LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(this.inputStream));
                while ((inputLine = lineReader.readLine()) != null) {
                    this.textBuffer.append(StringUtilities.replaceInvalidCharacters(inputLine)).append('\n');
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class InputReaderThread
    extends Thread {
        private StringBuffer inputText;

        public InputReaderThread(StringBuffer inputText) {
            this.inputText = inputText;
        }

        public void run() {
            byte[] buffer = new byte[1024];
            try {
                int bytesRead;
                while ((bytesRead = RunProcess.this.input.read(buffer)) > 0) {
                    String sub = new String(buffer, 0, bytesRead);
                    sub = sub.replace('\r', ' ');
                    sub = sub.replace('\t', ' ');
                    this.inputText.append(sub);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class ErrorReaderThread
    extends Thread {
        private StringBuffer errorText;

        public ErrorReaderThread(StringBuffer errorText) {
            this.errorText = errorText;
        }

        public void run() {
            byte[] buffer = new byte[1024];
            try {
                int bytesRead;
                while ((bytesRead = RunProcess.this.error.read(buffer)) > 0) {
                    String sub = new String(buffer, 0, bytesRead);
                    sub = sub.replace('\r', ' ');
                    sub = sub.replace('\t', ' ');
                    this.errorText.append(sub);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

