/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.MessageHandler;
import com.accurev.common.data.XMLTag;
import com.accurev.common.parsers.GenericXMLParser;
import com.accurev.common.parsers.ShowUsersParser;
import com.accurev.common.process.RunProcess;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;

public class SecurityProcess
extends RunProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int login(String userName, String password) {
        String[] cmds = new String[]{accurevExecutable, "login", "-G"};
        int commandStatus = this.execNoWait(cmds, null);
        if (commandStatus == 0) {
            try {
                OutputStreamWriter out = new OutputStreamWriter(this.runProcess.getOutputStream());
                BufferedWriter writer = new BufferedWriter(out);
                writer.write(userName);
                writer.newLine();
                writer.write(password);
                writer.newLine();
                writer.close();
                this.inputThread = new RunProcess.InputStreamReaderThread(this.input, this.responseText);
                this.errorThread = new RunProcess.InputStreamReaderThread(this.error, this.errorText);
                this.inputThread.start();
                this.errorThread.start();
                this.runProcess.waitFor();
                commandStatus = this.runProcess.exitValue();
                this.inputThread.join();
                this.errorThread.join();
                if (commandStatus != 0) {
                    String errorMessageText = this.responseText.toString() + this.errorText.toString();
                    if (errorMessageText.startsWith("Username: Password: ")) {
                        errorMessageText = errorMessageText.substring(20, errorMessageText.length());
                    }
                    if (errorMessageText.length() > 0) {
                        MessageHandler.showErrorMessage(errorMessageText);
                    }
                } else if (this.responseText.toString().startsWith("Username: Password: ")) {
                    this.responseText.delete(0, 20);
                }
            }
            catch (IOException e) {
                commandStatus = -100001;
            }
            catch (InterruptedException e) {
                commandStatus = -100002;
            }
            finally {
                this.closeProcess();
            }
        }
        return commandStatus;
    }

    public int logout() {
        String[] cmds = new String[]{accurevExecutable, "logout"};
        return this.exec(cmds, null);
    }

    public Vector runShowUsers() {
        return this.getUsers(false);
    }

    public Vector getUsers(boolean includeHidden) {
        String format = "-fx";
        if (includeHidden) {
            format = "-fix";
        }
        String[] commands = new String[]{accurevExecutable, "show", format, "users"};
        ShowUsersParser suParser = new ShowUsersParser();
        this.exec(commands, null, suParser);
        return suParser.getUserDataCollection();
    }

    public int[] getAccuRevServerVersion() {
        File serverInfoFile = null;
        PrintStream out = null;
        try {
            serverInfoFile = File.createTempFile("serverinfo", null);
            serverInfoFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(serverInfoFile));
        }
        catch (FileNotFoundException e) {
            return new int[0];
        }
        catch (IOException e) {
            return new int[0];
        }
        out.println("<serverInfo>");
        out.println("</serverInfo>");
        out.flush();
        out.close();
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", serverInfoFile.getAbsolutePath()};
        GenericXMLParser parserHandler = new GenericXMLParser();
        this.exec(cmds, null, parserHandler);
        List resultTags = parserHandler.getTagList();
        XMLTag acResponseTag = (XMLTag)resultTags.get(0);
        List acResponseTagList = acResponseTag.getTags();
        int[] serverVersion = new int[3];
        for (int i = 0; i < acResponseTagList.size(); ++i) {
            XMLTag tag = (XMLTag)acResponseTagList.get(i);
            if (!tag.getName().equals("serverVersion")) continue;
            String majorVersion = tag.getAttributeValue("major");
            String minorVersion = tag.getAttributeValue("minor");
            String patchVersion = tag.getAttributeValue("patch");
            serverVersion[0] = Integer.parseInt(majorVersion);
            serverVersion[1] = Integer.parseInt(minorVersion);
            serverVersion[2] = Integer.parseInt(patchVersion);
        }
        serverInfoFile.delete();
        return serverVersion;
    }

    public String getAccuRevAuthMethod() {
        String[] commands = new String[]{accurevExecutable, "authmethod"};
        this.exec(commands, null);
        String authMethodString = "";
        if (this.getCommandStatus() == 0) {
            authMethodString = this.getResponseText().toString().trim();
            authMethodString = authMethodString.substring(25);
            authMethodString = authMethodString.trim();
        }
        return authMethodString;
    }
}

