/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.parsers.TaskListParser;
import com.accurev.common.process.RunProcess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class TaskProcess
extends RunProcess {
    private TaskListParser taskListParser;

    public List getTaskList(String workDir) {
        File xmlFile = null;
        PrintStream out = null;
        try {
            xmlFile = File.createTempFile("xml", null);
            xmlFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(xmlFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println("<tasklist verbose=\"true\"></tasklist>");
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", xmlFile.getAbsolutePath()};
        this.taskListParser = new TaskListParser();
        this.execWithProgress(cmds, this.taskListParser);
        xmlFile.delete();
        return this.taskListParser.getTaskList();
    }

    public List getTaskProgress(String taskID) {
        File xmlFile = null;
        PrintStream out = null;
        try {
            xmlFile = File.createTempFile("xml", null);
            xmlFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(xmlFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println("<tasklist verbose=\"false\" taskid=\"" + taskID + "\"></tasklist>");
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", xmlFile.getAbsolutePath()};
        this.taskListParser = new TaskListParser(taskID);
        this.execWithProgress(cmds, this.taskListParser);
        xmlFile.delete();
        return this.taskListParser.getTaskProgress();
    }

    public int killTask(String taskID) {
        String[] cmds = new String[]{accurevExecutable, "kill", "-t", taskID};
        return this.exec(cmds, null, true);
    }
}

