/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process.thread;

import com.accurev.common.parsers.LogParser;
import com.accurev.common.process.thread.ProcessStatusListener;
import com.accurev.common.process.thread.ProcessThread;

public class LogProcessThread
extends ProcessThread {
    private String[] cmds;
    private String workingDir;
    private String processTitle = "";
    private String operationName = "";
    private int retValue = -1;
    private String logString;
    private boolean elementsChanged = false;

    public static LogProcessThread getUpdateProcessThread(String wspaceName, String wspaceDir, ProcessStatusListener listener) {
        String[] cmds = new String[]{accurevExecutable, "update", "-fx", "-Z", "-G", "-L", wspaceDir};
        if (listener == null) {
            throw new IllegalArgumentException("ProcessStatusListener is null");
        }
        LogProcessThread updateProcessThread = new LogProcessThread(cmds, wspaceDir, listener);
        updateProcessThread.processTitle = wspaceName;
        updateProcessThread.operationName = "Update";
        return updateProcessThread;
    }

    public static LogProcessThread getUpdatePreviewProcessThread(String wspaceName, String wspaceDir, ProcessStatusListener listener) {
        String[] cmds = new String[]{accurevExecutable, "update", "-fx", "-i", "-Z", "-G", "-L", wspaceDir};
        if (listener == null) {
            throw new IllegalArgumentException("ProcessStatusListener is null");
        }
        LogProcessThread updateProcessThread = new LogProcessThread(cmds, wspaceDir, listener);
        updateProcessThread.processTitle = wspaceName;
        updateProcessThread.operationName = "Update Preview";
        return updateProcessThread;
    }

    private LogProcessThread(String[] cmds, String workingDir, ProcessStatusListener listener) {
        this.cmds = cmds;
        this.workingDir = workingDir;
        this.progressListener = listener;
        this.thread.setPriority(10);
    }

    public void run() {
        LogParser logParser = new LogParser(this.operationName, this.progressListener, false);
        if (this.progressListener != null) {
            this.progressListener.initializeListener();
        }
        this.retValue = this.execWithAsyncParsing(this.cmds, this.workingDir, logParser);
        this.elementsChanged = logParser.isElementTagFound();
        if (this.progressListener != null) {
            this.progressListener.notifyProcessComplete(this.retValue == 0);
        }
        this.logString = logParser.getLogBuffer();
    }

    public String getTitle() {
        return this.processTitle;
    }

    public int getReturnValue() {
        return this.retValue;
    }

    public String getLogString() {
        return this.logString;
    }

    public boolean elementsChanged() {
        return this.elementsChanged;
    }
}

