/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.utils;

import com.accurev.common.Constants;
import com.accurev.common.utils.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

public class FileUtilities {
    public static boolean withinPath(String source, String destination) {
        boolean inPath = false;
        if (source == null || source.length() <= 0 || destination == null || destination.length() < source.length()) {
            return inPath;
        }
        inPath = Constants.IS_WINDOWS_OS ? destination.toLowerCase().startsWith(source.toLowerCase()) : destination.startsWith(source);
        char sourceChar = source.charAt(source.length() - 1);
        if (!inPath || FileUtilities.isPathSeparator(sourceChar) || destination.length() == source.length()) {
            return inPath;
        }
        char destinationChar = destination.charAt(source.length());
        if (!FileUtilities.isPathSeparator(destinationChar)) {
            inPath = false;
        }
        return inPath;
    }

    public static boolean isPathSeparator(char value) {
        return value == '/' || value == '\\';
    }

    public static String replaceCurrentDate(String fileName) {
        String tfPath = null;
        try {
            String oldBuffer = FileUtilities.readFromFile(fileName);
            long currentTime = System.currentTimeMillis() / 1000L;
            String newBuffer = StringUtilities.replaceAll(oldBuffer, "CUR_DATE", Long.toString(currentTime));
            tfPath = FileUtilities.createTemporaryFile(newBuffer);
        }
        catch (Exception e) {
            tfPath = null;
        }
        return tfPath;
    }

    public static String readFromFile(String fileName) throws FileNotFoundException, IOException {
        int bytesRead;
        StringBuffer inputBuffer = new StringBuffer();
        FileInputStream input = new FileInputStream(fileName);
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) > 0) {
            inputBuffer.append(StringUtilities.getString(buffer, bytesRead));
        }
        input.close();
        return inputBuffer.toString();
    }

    public static void writeToFile(File file, Object data) throws FileNotFoundException {
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        if (data instanceof Collection) {
            Iterator iter = ((Collection)data).iterator();
            while (iter.hasNext()) {
                printStream.println(iter.next().toString());
            }
        } else if (data != null) {
            printStream.println(data);
        }
        printStream.close();
    }

    public static String createTemporaryFile() {
        return FileUtilities.createTemporaryFile(null);
    }

    public static String createTemporaryFile(Object data) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tmp", null);
            tempFile.deleteOnExit();
            FileUtilities.writeToFile(tempFile, data);
        }
        catch (Exception e) {
            if (tempFile != null) {
                tempFile.delete();
            }
            tempFile = null;
        }
        return tempFile == null ? null : tempFile.getAbsolutePath();
    }

    public static void copyFile(File srcfile, File destfile) {
        byte[] bytearray = new byte[512];
        int len = 0;
        try {
            destfile.createNewFile();
            FileInputStream input = new FileInputStream(srcfile);
            FileOutputStream output = new FileOutputStream(destfile);
            while ((len = input.read(bytearray)) != -1) {
                output.write(bytearray, 0, len);
            }
            input.close();
            output.close();
        }
        catch (FileNotFoundException exc) {
        }
        catch (SecurityException exc) {
        }
        catch (IOException exc) {
            // empty catch block
        }
    }

    public static boolean comparePaths(String source, String destination) {
        boolean inPath = false;
        if (source == null || source.length() <= 0 || destination == null || destination.length() < source.length()) {
            return inPath;
        }
        File sourceFile = new File(source);
        File destinationFile = new File(destination);
        if (sourceFile.compareTo(destinationFile) == 0) {
            inPath = true;
        }
        return inPath;
    }
}

