/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

public class BuildAuthUtil {
    private static final String TEAM_CITY_BUILD_ID_PREFIX = "TeamCityBuildId=";

    private BuildAuthUtil() {
    }

    public static String makeUserId(long buildId) {
        return TEAM_CITY_BUILD_ID_PREFIX + buildId;
    }

    public static long getBuildId(String userId) {
        if (userId.length() < TEAM_CITY_BUILD_ID_PREFIX.length()) {
            return -1L;
        }
        String buildIdStr = userId.substring(TEAM_CITY_BUILD_ID_PREFIX.length());
        try {
            return Long.parseLong(buildIdStr);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean isAuthenticationByBuildId(String userId) {
        return userId.startsWith(TEAM_CITY_BUILD_ID_PREFIX);
    }
}

