/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

public final class BuildProblemData {
    public static final String TC_UNKNOWN_TYPE = "TC_UNKNOWN";
    public static final String TC_EXIT_CODE_TYPE = "TC_EXIT_CODE";
    public static final String TC_COMPILATION_ERROR_TYPE = "TC_COMPILATION_ERROR";
    public static final String TC_FAILED_TESTS_TYPE = "TC_FAILED_TESTS";
    public static final String TC_ERROR_MESSAGE_TYPE = "TC_ERROR_MESSAGE";
    public static final String TC_EXECUTION_TIMEOUT_TYPE = "TC_EXECUTION_TIMEOUT";
    public static final String TC_FEW_PASSED_TESTS_TYPE = "TC_FEW_PASSED_TESTS";
    public static final String TC_FEW_TESTS_TYPE = "TC_FEW_TESTS";
    public static final String TC_JVM_CRASH_TYPE = "TC_JVM_CRASH";
    public static final String TC_OOME_TYPE = "TC_OOME";
    public static final String TC_BUILD_STATUS_TYPE = "TC_BUILD_STATUS";
    public static final String TC_CONVERTED_TYPE = "TC_CONVERTED";
    public static final String TC_USER_PROVIDED_TYPE = "TC_USER_PROVIDED";
    public static final String TC_BUILD_FAILURE_TYPE = "TC_BUILD_FAILURE";
    public static final String TC_SERVICE_MESSAGE_TYPE = "TC_SERVICE_MESSAGE";
    public static final String TC_XML_STATUS_TYPE = "TC_XML_STATUS";
    public static final int MAX_IDENTITY_LENGTH = 60;
    public static final int MAX_TYPE_LENGTH = 80;
    public static final int MAX_DESCRIPTION_LENGTH = 4000;
    private final String myIdentity;
    private final String myType;
    private final String myDescription;

    private BuildProblemData(String identity, String type, String description) throws IllegalArgumentException {
        if (identity == null) {
            throw new IllegalArgumentException("identity shouldn't be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type shouldn't be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description shouldn't be null");
        }
        if (identity.length() == 0) {
            throw new IllegalArgumentException("identity shouldn't be empty");
        }
        if (type.length() == 0) {
            throw new IllegalArgumentException("type shouldn't be empty");
        }
        if (identity.length() > 60) {
            throw new IllegalArgumentException("identity shouldn't be longer than 60 characters: " + identity);
        }
        if (type.length() > 80) {
            throw new IllegalArgumentException("type shouldn't be longer than 80 characters: " + type);
        }
        this.myIdentity = identity;
        this.myType = type;
        this.myDescription = description;
    }

    public String getType() {
        return this.myType;
    }

    public String getIdentity() {
        return this.myIdentity;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String toString() {
        return BuildProblemData.asString(this.myIdentity, this.myType, this.myDescription);
    }

    public static String asString(String identity, String type, String description) {
        return "BuildProblemData{myIdentity=" + identity + ", myType='" + type + '\'' + ", myDescription='" + description + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildProblemData)) {
            return false;
        }
        BuildProblemData that = (BuildProblemData)o;
        return this.myIdentity.equals(that.myIdentity);
    }

    public int hashCode() {
        return this.myIdentity.hashCode();
    }

    public static BuildProblemData createBuildProblem(String identity, String type, String description) {
        return new BuildProblemData(identity, type, description);
    }

    public static BuildProblemData createSingletonBuildProblem(String type, String description) {
        return BuildProblemData.createBuildProblem(type, type, description);
    }

    public static BuildProblemData createBuildProblemWithPrefix(String identity, String type, String description) {
        return BuildProblemData.createBuildProblem(type.concat("_").concat(identity), type, description);
    }
}

