/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class StreamGobbler
extends Thread {
    private static final Logger LOG = Logger.getInstance((String)StreamGobbler.class.getName());
    private final ByteArrayOutputStream myByteContents;
    private final InputStream is;
    private String myOutput;
    private volatile boolean myProcessExited = false;
    private volatile boolean myEndReached = false;

    public StreamGobbler(InputStream is) {
        this.is = is;
        this.myByteContents = new ByteArrayOutputStream();
    }

    public void notifyProcessExit() {
        this.myProcessExited = true;
    }

    public void run() {
        byte[] buffer = new byte[8192];
        try {
            while (!this.myEndReached) {
                Thread.yield();
                boolean probablyHasMoreData = false;
                if (this.is.available() > 0) {
                    Thread.yield();
                    probablyHasMoreData = this.readBuffer(buffer);
                } else if (this.myProcessExited) break;
                if (probablyHasMoreData) continue;
                Thread.sleep(10L);
            }
        }
        catch (IOException ioe) {
            LOG.debug(ioe.getMessage(), (Throwable)ioe);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean readBuffer(byte[] buffer) throws IOException {
        int read = this.is.read(buffer, 0, buffer.length);
        if (read != -1) {
            this.myByteContents.write(buffer, 0, read);
            return read == buffer.length;
        }
        this.myEndReached = true;
        return false;
    }

    public String getReadString(Charset encoding) {
        if (this.myOutput == null) {
            try {
                this.myOutput = StringUtil.convertLineSeparators((String)this.myByteContents.toString(encoding.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to convert output to encoding " + encoding, e);
            }
        }
        return this.myOutput;
    }

    public byte[] getReadBytes() {
        return this.myByteContents.toByteArray();
    }

    public long getReadLength() {
        return this.myByteContents.size();
    }
}

