/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import jetbrains.buildServer.TCNonValidatedSAXParser;
import jetbrains.buildServer.TCNonValidatedSAXParserWithDebug;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.apache.xmlrpc.XmlRpc;

public class TCXmlRpcConfigurator {
    private TCXmlRpcConfigurator() {
    }

    public static void ConfigureXmlRpc() {
        if (TeamCityProperties.getBoolean("xml-rpc-sax-debug")) {
            XmlRpc.setDriver(TCNonValidatedSAXParserWithDebug.class);
        } else {
            try {
                if (TeamCityProperties.getPropertyOrNull("sax.driver") == null) {
                    XmlRpc.setDriver(TCNonValidatedSAXParser.class);
                }
            }
            catch (Throwable e) {
                Logger logger = Logger.getInstance((String)TCXmlRpcConfigurator.class.getName());
                logger.warn("Unable to load SAX parser for XML-RPC: " + e.getLocalizedMessage());
                logger.warn("Use system property sax.driver to specify class name of the alternative SAX driver.");
                logger.debug(e.getMessage(), e);
            }
        }
    }
}

