/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.XStream;
import java.util.Date;
import java.util.TimeZone;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.xstream.XStreamWrapper;
import org.jetbrains.annotations.NotNull;

public class AgentBuildResult {
    private final long myBuildStartTimeMilliseconds;
    @NotNull
    private final String myAgentTimeZone;

    public AgentBuildResult() {
        this(System.currentTimeMillis());
    }

    public AgentBuildResult(long buildStartTimeMilliseconds) {
        this(new Date(buildStartTimeMilliseconds));
    }

    public AgentBuildResult(@NotNull Date buildStartTime) {
        if (buildStartTime == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuildResult.<init> must not be null");
        }
        this.myBuildStartTimeMilliseconds = buildStartTime.getTime();
        this.myAgentTimeZone = TimeZone.getDefault().getID();
    }

    /*
     * WARNING - void declaration
     */
    public AgentBuildResult(long buildStartTimeMilliseconds, @NotNull String string) {
        void agentTimeZone;
        if (string == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuildResult.<init> must not be null");
        }
        this.myBuildStartTimeMilliseconds = buildStartTimeMilliseconds;
        this.myAgentTimeZone = agentTimeZone;
    }

    @NotNull
    public Date getAgentBuildStartTimeUTC() {
        Date date = new Date(this.myBuildStartTimeMilliseconds);
        if (date == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuildResult.getAgentBuildStartTimeUTC must not return null");
        }
        return date;
    }

    @NotNull
    public TimeZone getAgentTimeZone() {
        TimeZone timeZone = TimeZone.getTimeZone(this.myAgentTimeZone);
        if (timeZone == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuildResult.getAgentTimeZone must not return null");
        }
        return timeZone;
    }

    @NotNull
    public String serialize() {
        String string = XStreamWrapper.serializeObject(this, AgentBuildResult.createXStreamHolder());
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuildResult.serialize must not return null");
        }
        return string;
    }

    @NotNull
    public static AgentBuildResult deserialize(@NotNull String serialized) {
        if (serialized == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuildResult.deserialize must not be null");
        }
        AgentBuildResult agentBuildResult = (AgentBuildResult)XStreamWrapper.deserializeObject(serialized, AgentBuildResult.createXStreamHolder());
        if (agentBuildResult == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuildResult.deserialize must not return null");
        }
        return agentBuildResult;
    }

    @NotNull
    private static XStreamHolder createXStreamHolder() {
        XStreamHolder xStreamHolder = new XStreamHolder(){

            protected void configureXStream(XStream xStream) {
                xStream.alias("AgentBuildResult", AgentBuildResult.class);
            }
        };
        if (xStreamHolder == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuildResult.createXStreamHolder must not return null");
        }
        return xStreamHolder;
    }

    public String toString() {
        return "AgentBuildResult{myBuildStartTimeMilliseconds='" + this.myBuildStartTimeMilliseconds + "', myAgentTimeZone='" + this.myAgentTimeZone + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentBuildResult that = (AgentBuildResult)o;
        if (this.myBuildStartTimeMilliseconds != that.myBuildStartTimeMilliseconds) {
            return false;
        }
        return this.myAgentTimeZone.equals(that.myAgentTimeZone);
    }

    public int hashCode() {
        int result = (int)(this.myBuildStartTimeMilliseconds ^ this.myBuildStartTimeMilliseconds >>> 32);
        result = 31 * result + this.myAgentTimeZone.hashCode();
        return result;
    }
}

