/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.VcsRootEntry;
import jetbrains.buildServer.vcs.impl.VcsRootImpl;
import org.jetbrains.annotations.NotNull;

class VcsRootEntryConverter
implements Converter {
    VcsRootEntryConverter() {
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        VcsRootEntry vcsRootEntry = (VcsRootEntry)o;
        writer.startNode("vcsRoot");
        writer.addAttribute("id", String.valueOf(vcsRootEntry.getVcsRoot().getId()));
        writer.setValue(vcsRootEntry.getVcsRoot().convertToString());
        writer.endNode();
        writer.startNode("checkoutRules");
        writer.setValue(vcsRootEntry.getCheckoutRules().getAsString());
        writer.endNode();
        writer.startNode("signature");
        writer.setValue(vcsRootEntry.getSignature());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        reader.moveDown();
        long vcsRootId = Long.parseLong(reader.getAttribute("id"));
        String serialized = reader.getValue();
        VcsRootImpl vcsRoot = new VcsRootImpl(vcsRootId, VcsRootImpl.stringToProperties(serialized));
        reader.moveUp();
        reader.moveDown();
        CheckoutRules rules = new CheckoutRules(reader.getValue());
        reader.moveUp();
        reader.moveDown();
        final String signature = reader.getValue();
        reader.moveUp();
        return new VcsRootEntry(vcsRoot, rules){

            @NotNull
            public String getSignature() {
                String string = signature;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/VcsRootEntryConverter$1.getSignature must not return null");
                }
                return string;
            }
        };
    }

    public boolean canConvert(Class aClass) {
        return VcsRootEntry.class.isAssignableFrom(aClass);
    }
}

