/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jetbrains.buildServer.configuration.ChangeObserver;
import jetbrains.buildServer.configuration.ChangeProvider;
import jetbrains.buildServer.configuration.WatchedFileState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesWatcher
extends ChangeObserver
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)FilesWatcher.class.getName());
    private FilesState myFilesState;
    private final WatchedFilesProvider myFilesProvider;

    public FilesWatcher(WatchedFilesProvider filesProvider) {
        super(10000L);
        this.myFilesProvider = filesProvider;
        this.registerChangeProvider(this);
        this.resetState();
    }

    private void resetState() {
        try {
            this.myFilesState = new FilesState();
            this.myFilesState.addToState(this.myFilesProvider.getWatchedFiles());
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean changesDetected() {
        try {
            File[] watchedFiles = this.myFilesProvider.getWatchedFiles();
            return this.myFilesState.computeChanges(watchedFiles);
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
            return false;
        }
    }

    public List<File> getNewFiles() {
        return Collections.unmodifiableList(this.myFilesState.myNewFiles);
    }

    public List<File> getRemovedFiles() {
        return Collections.unmodifiableList(this.myFilesState.myRemovedFiles);
    }

    public List<File> getModifiedFiles() {
        return Collections.unmodifiableList(this.myFilesState.myModifiedFiles);
    }

    @Override
    public synchronized void resetChanged() {
        this.resetState();
    }

    public synchronized void resetChanged(File ... files) {
        for (File file : files) {
            this.myFilesState.resetFileState(file);
        }
    }

    @Override
    public String getRequestor() {
        return "FilesWatcher";
    }

    private static class FilesState {
        private final Map<String, WatchedFileState> myFilesState = new HashMap<String, WatchedFileState>();
        private final List<File> myNewFiles = new Vector<File>();
        private final List<File> myRemovedFiles = new Vector<File>();
        private final List<File> myModifiedFiles = new Vector<File>();

        FilesState() {
        }

        void addToState(File ... watchedFiles) {
            for (File watchedFile : watchedFiles) {
                this.myFilesState.put(watchedFile.getAbsolutePath(), new WatchedFileState(watchedFile));
            }
        }

        void resetFileState(File file) {
            WatchedFileState fs = this.myFilesState.get(file.getAbsolutePath());
            if (fs != null) {
                this.addToState(file);
            }
        }

        boolean computeChanges(File[] files) {
            this.myNewFiles.clear();
            this.myRemovedFiles.clear();
            this.myModifiedFiles.clear();
            HashSet<String> filesPaths = new HashSet<String>();
            for (File file : files) {
                if (!this.myFilesState.containsKey(file.getAbsolutePath())) {
                    this.myNewFiles.add(file);
                } else {
                    WatchedFileState watchedFile = this.myFilesState.get(file.getAbsolutePath());
                    if (watchedFile.isCreated(file)) {
                        this.myNewFiles.add(file);
                    } else if (watchedFile.isChanged(file)) {
                        this.myModifiedFiles.add(file);
                    }
                }
                filesPaths.add(file.getAbsolutePath());
            }
            for (String path : this.myFilesState.keySet()) {
                if (filesPaths.contains(path)) continue;
                this.myRemovedFiles.add(new File(path));
            }
            return this.myNewFiles.size() > 0 || this.myRemovedFiles.size() > 0 || this.myModifiedFiles.size() > 0;
        }
    }

    public static interface WatchedFilesProvider {
        public File[] getWatchedFiles() throws IOException;
    }
}

