/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.buildServer.dataStructures.Mapper;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingIterator<T, Q>
implements Iterator<T> {
    private final Iterator<Q> myIterator;
    private final Mapper<Q, T> myMapper;
    private T myNextValue;

    public DecoratingIterator(@NotNull Iterator<Q> iterator, @NotNull Mapper<Q, T> mapper) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingIterator.<init> must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/dataStructures/DecoratingIterator.<init> must not be null");
        }
        this.myNextValue = null;
        this.myIterator = iterator;
        this.myMapper = mapper;
    }

    @Override
    public boolean hasNext() {
        if (this.myNextValue != null) {
            return true;
        }
        while (this.myIterator.hasNext()) {
            this.myNextValue = this.myMapper.mapKey(this.myIterator.next());
            if (this.myNextValue == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.myNextValue != null || this.hasNext()) {
            T val = this.myNextValue;
            this.myNextValue = null;
            return val;
        }
        throw new NoSuchElementException("Collection is empty");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("collection is readonly");
    }
}

