/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jetbrains.buildServer.BuildProblemData;
import jetbrains.buildServer.messages.BlockData;
import jetbrains.buildServer.messages.BuildMessage1;
import jetbrains.buildServer.messages.ComparisonFailedData;
import jetbrains.buildServer.messages.ErrorData;
import jetbrains.buildServer.messages.FlowData;
import jetbrains.buildServer.messages.IgnoredTestData;
import jetbrains.buildServer.messages.Status;
import jetbrains.buildServer.messages.TestFinishBlockData;
import jetbrains.buildServer.messages.TestOutputData;
import jetbrains.buildServer.messages.TestProblemData;
import jetbrains.buildServer.messages.TestStartBlockData;

public class BuildMessage1Converter
extends ReflectionConverter {
    private static final String TAG_SEPARATOR = ",";
    private static final String STANDARD_PACKAGE_PREFIX = "jetbrains.buildServer.messages.";
    private static final Map myPooledStrings = new HashMap();
    private static final Set myFields;
    private static final Map myClassNameAliases;
    private static final Map myValueConverters;

    public BuildMessage1Converter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Collection tags;
        BuildMessage1 msg = (BuildMessage1)source;
        HashMap<String, String> values = new HashMap<String, String>();
        if (!"DefaultMessage".equals(msg.getSourceId())) {
            values.put("f1", msg.getSourceId());
        }
        values.put("f2", msg.getTypeId());
        if (!msg.getStatus().equals(Status.NORMAL)) {
            values.put("f3", String.valueOf(msg.getStatus().getPriority()));
        }
        values.put("f4", String.valueOf(msg.getTimestamp().getTime()));
        if (!msg.getFlowId().equals("")) {
            values.put("f5", msg.getFlowId());
        }
        if ((tags = msg.getTags()) != null && !tags.isEmpty()) {
            StringBuffer b = new StringBuffer();
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof String)) continue;
                if (b.length() > 0) {
                    b.append(TAG_SEPARATOR);
                }
                b.append(next.toString().trim());
            }
            values.put("f6", b.toString());
        }
        BuildMessage1Converter.marshalMap(writer, values);
        if (msg.getValue() != null) {
            writer.startNode("v1");
            Class<?> valueClass = msg.getValue().getClass();
            Converter valueConverter = (Converter)myValueConverters.get(valueClass.getName());
            String className = valueClass.getName();
            if (className.startsWith(STANDARD_PACKAGE_PREFIX)) {
                className = className.substring(STANDARD_PACKAGE_PREFIX.length());
            }
            writer.addAttribute("class", className);
            if (valueConverter != null) {
                valueConverter.marshal(msg.getValue(), writer, context);
            } else {
                context.convertAnother(msg.getValue());
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Object value = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (myFields.contains(nodeName)) {
                fieldValues.put(nodeName, reader.getValue());
            } else if ("v1".equals(nodeName) || "myValue".equals(nodeName)) {
                Converter valueConverter;
                String className = reader.getAttribute("class");
                if (className != null && className.indexOf(46) == -1) {
                    className = STANDARD_PACKAGE_PREFIX + className;
                }
                if ((valueConverter = (Converter)myValueConverters.get(className)) != null) {
                    value = valueConverter.unmarshal(reader, context);
                } else {
                    try {
                        String alias = (String)myClassNameAliases.get(className);
                        if (alias != null) {
                            className = alias;
                        }
                        if (className != null) {
                            Class<?> clazz = Class.forName(className);
                            value = context.convertAnother(context.currentObject(), clazz);
                        } else {
                            value = null;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConversionException("Cannot load class: " + className, (Throwable)e);
                    }
                }
            }
            reader.moveUp();
        }
        String sourceId = BuildMessage1Converter.fieldValue(fieldValues, "f1", "mySourceId");
        if (sourceId == null) {
            sourceId = "DefaultMessage";
        }
        String typeId = BuildMessage1Converter.getPooled(BuildMessage1Converter.fieldValue(fieldValues, "f2", "myTypeId"));
        String status = BuildMessage1Converter.fieldValue(fieldValues, "f3", "myStatus");
        if (status == null) {
            status = String.valueOf(Status.NORMAL.getPriority());
        }
        int priority = Integer.parseInt(status);
        long tstmp = Long.parseLong(BuildMessage1Converter.fieldValue(fieldValues, "f4", "myTimestamp"));
        String flowId = BuildMessage1Converter.fieldValue(fieldValues, "f5", "myFlowId");
        if (flowId == null) {
            flowId = "";
        }
        ArrayList<String> tags = null;
        String tagsStr = BuildMessage1Converter.fieldValue(fieldValues, "f6", "myTags");
        if (tagsStr != null) {
            StringTokenizer tok = new StringTokenizer(tagsStr, TAG_SEPARATOR);
            tags = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreTokens()) {
                tags.add(tok.nextToken());
            }
        }
        BuildMessage1 msg = new BuildMessage1(sourceId, typeId, Status.getStatus(priority), new Date(tstmp), value, tags);
        msg.updateFlowId(flowId);
        return msg;
    }

    private static String getPooled(String notPooled) {
        String pooled = (String)myPooledStrings.get(notPooled);
        if (pooled != null) {
            return pooled;
        }
        return notPooled;
    }

    private static String fieldValue(Map fieldValues, String key1, String key2) {
        String val = (String)fieldValues.get(key1);
        if (val != null) {
            return val;
        }
        return (String)fieldValues.get(key2);
    }

    public boolean canConvert(Class type) {
        return BuildMessage1.class == type;
    }

    private static Map unmarshalToMap(HierarchicalStreamReader reader) {
        HashMap<String, String> values = new HashMap<String, String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            values.put(reader.getNodeName(), reader.getValue());
            reader.moveUp();
        }
        return values;
    }

    private static void marshalMap(HierarchicalStreamWriter writer, Map values) {
        Iterator it = values.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() == null) continue;
            writer.startNode((String)entry.getKey());
            writer.setValue((String)entry.getValue());
            writer.endNode();
        }
    }

    static {
        myPooledStrings.put("DefaultMessage", "DefaultMessage");
        myPooledStrings.put("BlockStart", "BlockStart");
        myPooledStrings.put("BlockEnd", "BlockEnd");
        myPooledStrings.put("$TEST_SUITE$", "$TEST_SUITE$");
        myPooledStrings.put("$TEST_BLOCK$", "$TEST_BLOCK$");
        myPooledStrings.put("$BUILD_PROGRESS$", "$BUILD_PROGRESS$");
        myPooledStrings.put("TestOutput", "TestOutput");
        myPooledStrings.put("TestIgnored", "TestIgnored");
        myPooledStrings.put("TestFailure", "TestFailure");
        myFields = new HashSet();
        myFields.add("mySourceId");
        myFields.add("myTypeId");
        myFields.add("myStatus");
        myFields.add("myTimestamp");
        myFields.add("myFlowId");
        myFields.add("myTags");
        myFields.add("f1");
        myFields.add("f2");
        myFields.add("f3");
        myFields.add("f4");
        myFields.add("f5");
        myFields.add("f6");
        myClassNameAliases = new HashMap();
        myClassNameAliases.put("set", Set.class.getName());
        myClassNameAliases.put("list", List.class.getName());
        myValueConverters = new HashMap();
        Converter stringConverter = new Converter(){

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.setValue((String)source);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                return reader.getValue();
            }

            public boolean canConvert(Class type) {
                return type == (class$java$lang$String == null ? (class$java$lang$String = BuildMessage1Converter.class$("java.lang.String")) : class$java$lang$String);
            }
        };
        myValueConverters.put(String.class.getName(), stringConverter);
        myValueConverters.put("string", stringConverter);
        myValueConverters.put(BlockData.class.getName(), new BlockDataConverter());
        myValueConverters.put(TestOutputData.class.getName(), new TestOutputDataConverter());
        myValueConverters.put(ErrorData.class.getName(), new ErrorDataConverter());
        myValueConverters.put(TestProblemData.class.getName(), new TestProblemDataConverter());
        myValueConverters.put(TestStartBlockData.class.getName(), new TestStartBlockDataConverter());
        myValueConverters.put(TestFinishBlockData.class.getName(), new TestFinishBlockDataConverter());
        myValueConverters.put(IgnoredTestData.class.getName(), new IgnoredTestDataConverter());
        myValueConverters.put(FlowData.class.getName(), new FlowDataConverter());
        myValueConverters.put(ComparisonFailedData.class.getName(), new ComparisonFailedDataConverter());
        myValueConverters.put(BuildProblemData.class.getName(), new BuildProblemDataConverter());
    }

    public static class BuildProblemDataConverter
    implements Converter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            BuildProblemData buildProblem = (BuildProblemData)source;
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("identity", buildProblem.getIdentity());
            values.put("type", buildProblem.getType());
            values.put("descr", buildProblem.getDescription());
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return BuildProblemData.createBuildProblem((String)values.get("identity"), (String)values.get("type"), (String)values.get("descr"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$BuildProblemData == null ? (class$jetbrains$buildServer$BuildProblemData = BuildMessage1Converter.class$("jetbrains.buildServer.BuildProblemData")) : class$jetbrains$buildServer$BuildProblemData) == type;
        }
    }

    public static class ComparisonFailedDataConverter
    extends TestProblemDataConverter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal(source, writer, context);
            ComparisonFailedData failureData = (ComparisonFailedData)source;
            HashMap<String, String> values = new HashMap<String, String>();
            if (failureData.expected != null) {
                values.put("expected", failureData.expected);
            }
            if (failureData.actual != null) {
                values.put("actual", failureData.actual);
            }
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return new ComparisonFailedData((String)values.get("testName"), (String)values.get("stackTrace"), (String)values.get("localizedMessage"), (String)values.get("expected"), (String)values.get("actual"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$ComparisonFailedData == null ? (class$jetbrains$buildServer$messages$ComparisonFailedData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.ComparisonFailedData")) : class$jetbrains$buildServer$messages$ComparisonFailedData) == type;
        }
    }

    public static class FlowDataConverter
    implements Converter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            FlowData flowData = (FlowData)source;
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("myFlow", flowData.getFlow());
            values.put("myParentFlow", flowData.getParentFlow());
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return new FlowData((String)values.get("myFlow"), (String)values.get("myParentFlow"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$FlowData == null ? (class$jetbrains$buildServer$messages$FlowData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.FlowData")) : class$jetbrains$buildServer$messages$FlowData) == type;
        }
    }

    public static class TestFinishBlockDataConverter
    extends BlockDataConverter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal(source, writer, context);
            TestFinishBlockData testData = (TestFinishBlockData)source;
            HashMap<String, String> values = new HashMap<String, String>();
            if (testData.getDuration() != null) {
                values.put("myDuration", testData.getDuration().toString());
            }
            if (testData.getFinishTimestamp() != null) {
                values.put("myFinishTimestamp", testData.getFinishTimestamp().toString());
            }
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            String durationStr = (String)values.get("myDuration");
            String timestampStr = (String)values.get("myFinishTimestamp");
            Integer duration = durationStr != null ? new Integer(durationStr) : null;
            Long tstmp = timestampStr != null ? new Long(timestampStr) : null;
            return new TestFinishBlockData((String)values.get("blockName"), BuildMessage1Converter.getPooled((String)values.get("blockType")), duration, tstmp);
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$TestFinishBlockData == null ? (class$jetbrains$buildServer$messages$TestFinishBlockData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.TestFinishBlockData")) : class$jetbrains$buildServer$messages$TestFinishBlockData) == type;
        }
    }

    public static class IgnoredTestDataConverter
    implements Converter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            IgnoredTestData testData = (IgnoredTestData)source;
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("testName", testData.testName);
            if (testData.ignoreReason != null) {
                values.put("ignoreReason", testData.ignoreReason);
            }
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return new IgnoredTestData((String)values.get("testName"), (String)values.get("ignoreReason"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$IgnoredTestData == null ? (class$jetbrains$buildServer$messages$IgnoredTestData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.IgnoredTestData")) : class$jetbrains$buildServer$messages$IgnoredTestData) == type;
        }
    }

    public static class TestStartBlockDataConverter
    extends BlockDataConverter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal(source, writer, context);
            TestStartBlockData blockData = (TestStartBlockData)source;
            HashMap<String, String> values = new HashMap<String, String>();
            if (blockData.getStartTimestamp() != null) {
                values.put("myStartTimestamp", String.valueOf(blockData.getStartTimestamp()));
            }
            values.put("myLocationHint", blockData.getLocationHint());
            values.put("myCaptureStandardOutput", String.valueOf(blockData.isCaptureStandardOutput()));
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            String timestampStr = (String)values.get("myStartTimestamp");
            Long tstmp = timestampStr == null ? null : new Long(timestampStr);
            return new TestStartBlockData((String)values.get("blockName"), BuildMessage1Converter.getPooled((String)values.get("blockType")), Boolean.valueOf((String)values.get("myCaptureStandardOutput")), tstmp, (String)values.get("myLocationHint"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$TestStartBlockData == null ? (class$jetbrains$buildServer$messages$TestStartBlockData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.TestStartBlockData")) : class$jetbrains$buildServer$messages$TestStartBlockData) == type;
        }
    }

    public static class ErrorDataConverter
    implements Converter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            HashMap<String, String> values = new HashMap<String, String>();
            ErrorData problem = (ErrorData)source;
            if (problem.stackTrace != null) {
                values.put("stackTrace", problem.stackTrace);
            }
            if (problem.localizedMessage != null) {
                values.put("localizedMessage", problem.localizedMessage);
            }
            if (problem.type != null) {
                values.put("type", problem.type);
            }
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return new ErrorData((String)values.get("stackTrace"), (String)values.get("localizedMessage"), (String)values.get("type"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$ErrorData == null ? (class$jetbrains$buildServer$messages$ErrorData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.ErrorData")) : class$jetbrains$buildServer$messages$ErrorData) == type;
        }
    }

    public static class TestProblemDataConverter
    extends ErrorDataConverter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal(source, writer, context);
            TestProblemData problem = (TestProblemData)source;
            writer.startNode("testName");
            writer.setValue(problem.testName);
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return new TestProblemData((String)values.get("testName"), (String)values.get("stackTrace"), (String)values.get("localizedMessage"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$TestProblemData == null ? (class$jetbrains$buildServer$messages$TestProblemData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.TestProblemData")) : class$jetbrains$buildServer$messages$TestProblemData) == type;
        }
    }

    public static class TestOutputDataConverter
    implements Converter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            HashMap<String, String> values = new HashMap<String, String>();
            TestOutputData testOutput = (TestOutputData)source;
            values.put("testName", testOutput.testName);
            if (testOutput.text != null) {
                values.put("text", testOutput.text);
            }
            values.put("isStdOut", String.valueOf(testOutput.isStdOut));
            BuildMessage1Converter.marshalMap(writer, values);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return new TestOutputData((String)values.get("testName"), Boolean.valueOf((String)values.get("isStdOut")), (String)values.get("text"));
        }

        public boolean canConvert(Class type) {
            return (class$jetbrains$buildServer$messages$TestOutputData == null ? (class$jetbrains$buildServer$messages$TestOutputData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.TestOutputData")) : class$jetbrains$buildServer$messages$TestOutputData) == type;
        }
    }

    public static class BlockDataConverter
    implements Converter {
        public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
            BlockData block = (BlockData)original;
            writer.startNode("blockName");
            writer.setValue(block.blockName);
            writer.endNode();
            writer.startNode("blockType");
            writer.setValue(block.blockType);
            writer.endNode();
            if (block.blockDescription != null && block.blockDescription.length() > 0) {
                writer.startNode("blockDescription");
                writer.setValue(block.blockDescription);
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map values = BuildMessage1Converter.unmarshalToMap(reader);
            return new BlockData((String)values.get("blockName"), (String)values.get("blockType"), (String)values.get("blockDescription"));
        }

        public boolean canConvert(Class type) {
            return type == (class$jetbrains$buildServer$messages$BlockData == null ? (class$jetbrains$buildServer$messages$BlockData = BuildMessage1Converter.class$("jetbrains.buildServer.messages.BlockData")) : class$jetbrains$buildServer$messages$BlockData);
        }
    }
}

