/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import java.util.Date;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.agent.JUnitLogger;
import jetbrains.buildServer.messages.DefaultMessagesInfo;

public class DefaultJUnitLogger
implements JUnitLogger {
    private final BuildProgressLogger myProgressLogger;

    public DefaultJUnitLogger(BuildProgressLogger progressLogger) {
        this.myProgressLogger = progressLogger;
    }

    public void logTestStarted(String name) {
        this.myProgressLogger.activityStarted(name, "$TEST_BLOCK$");
    }

    public void logTestStarted(String name, Date timestamp) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createBlockStart(name, "$TEST_BLOCK$", timestamp));
    }

    public void logTestFinished(String name) {
        this.myProgressLogger.activityFinished(name, "$TEST_BLOCK$");
    }

    public void logTestFinished(String name, Date timestamp) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createBlockEnd(name, "$TEST_BLOCK$", timestamp));
    }

    public void logTestIgnored(String name, String reason) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createTestIgnoreMessage(name, reason));
    }

    public void logSuiteStarted(String name) {
        this.myProgressLogger.activityStarted(name, "$TEST_SUITE$");
    }

    public void logSuiteStarted(String name, Date timestamp) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createBlockStart(name, "$TEST_SUITE$", timestamp));
    }

    public void logSuiteFinished(String name) {
        this.myProgressLogger.activityFinished(name, "$TEST_SUITE$");
    }

    public void logSuiteFinished(String name, Date timestamp) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createBlockEnd(name, "$TEST_SUITE$", timestamp));
    }

    public void logTestStdOut(String testName, String out) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createTestStdout(testName, out));
    }

    public void logTestStdErr(String testName, String out) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createTestStderr(testName, out));
    }

    public void logComparisonFailure(String testName, Throwable e, String expected, String actual) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createComparisonFailed(testName, e, expected, actual));
    }

    public void logTestFailed(String testName, Throwable e) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createTestFailure(testName, e));
    }

    public void logTestFailed(String testName, String message, String stackTrace) {
        this.myProgressLogger.logMessage(DefaultMessagesInfo.createTestFailure(testName, message, stackTrace));
    }

    public void flush() {
        this.myProgressLogger.flush();
    }
}

