/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import jetbrains.buildServer.messages.BuildMessage1;
import jetbrains.buildServer.messages.BuildMessage1Converter;
import jetbrains.buildServer.messages.DateConverter;
import jetbrains.buildServer.messages.StatusConverter;
import jetbrains.buildServer.messages.XStreamHolder;

public class MessagesPersistence {
    private static final byte[] BUFF = new byte[2048];
    private static final XStreamHolder ourXStreamHolder = new XStreamHolder(){

        protected void configureXStream(XStream xStream) {
            xStream.registerConverter((SingleValueConverter)new StringConverter(), 1);
            xStream.registerConverter((SingleValueConverter)new StatusConverter());
            xStream.registerConverter((SingleValueConverter)new DateConverter());
            xStream.registerConverter((Converter)new BuildMessage1Converter(xStream.getMapper(), xStream.getReflectionProvider()));
            xStream.alias("bm", class$jetbrains$buildServer$messages$BuildMessage1 == null ? (class$jetbrains$buildServer$messages$BuildMessage1 = MessagesPersistence.class$("jetbrains.buildServer.messages.BuildMessage1")) : class$jetbrains$buildServer$messages$BuildMessage1);
        }
    };
    static /* synthetic */ Class class$jetbrains$buildServer$messages$BuildMessage1;
    static /* synthetic */ Class class$java$lang$String;

    private MessagesPersistence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String readString(DataInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        char[] chars = new char[length];
        int charsRead = 0;
        while (charsRead < length) {
            byte[] byArray = BUFF;
            // MONITORENTER : BUFF
            byte[] buff = BUFF;
            int bytesRead = Math.min(length - charsRead << 1, buff.length);
            in.readFully(buff, 0, bytesRead);
            for (int i = 0; i < bytesRead; i += 2) {
                chars[charsRead++] = (char)((buff[i] << 8) + (buff[i + 1] & 0xFF));
            }
            // MONITOREXIT : byArray
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void writeString(String s, DataOutput out) throws IOException {
        if (s == null) {
            out.writeInt(-1);
            return;
        }
        int len = s.length();
        out.writeInt(len);
        if (len == 0) {
            return;
        }
        int charsWritten = 0;
        while (charsWritten < len) {
            byte[] byArray = BUFF;
            // MONITORENTER : BUFF
            byte[] buff = BUFF;
            int bytesWritten = Math.min(len - charsWritten << 1, buff.length);
            for (int i = 0; i < bytesWritten; i += 2) {
                char aChar = s.charAt(charsWritten++);
                buff[i] = (byte)(aChar >>> 8 & 0xFF);
                buff[i + 1] = (byte)(aChar & 0xFF);
            }
            out.write(buff, 0, bytesWritten);
            // MONITOREXIT : byArray
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toXml(BuildMessage1 message) {
        XStream xStream = ourXStreamHolder.getXStream();
        try {
            StringWriter writer = new StringWriter();
            xStream.marshal((Object)message, (HierarchicalStreamWriter)new CompactWriter((Writer)writer));
            String string = writer.toString();
            return string;
        }
        finally {
            ourXStreamHolder.releaseXStream(xStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildMessage1 fromXml(String xml) {
        XStream xStream = ourXStreamHolder.getXStream();
        try {
            BuildMessage1 buildMessage1 = (BuildMessage1)(xml.length() > 0 ? xStream.fromXML(xml) : null);
            return buildMessage1;
        }
        finally {
            ourXStreamHolder.releaseXStream(xStream);
        }
    }

    public static XStreamHolder getMessagesXStreamHolder() {
        return ourXStreamHolder;
    }

    public static class StringConverter
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return type == (class$java$lang$String == null ? (class$java$lang$String = MessagesPersistence.class$("java.lang.String")) : class$java$lang$String);
        }

        public String toString(Object obj) {
            return (String)obj;
        }

        public Object fromString(String str) {
            return str;
        }
    }
}

