/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import java.io.Serializable;

public final class Status
implements Serializable {
    public static final Status UNKNOWN = new Status(0, "UNKNOWN", "#3f3f3f");
    public static final Status NORMAL = new Status(1, "NORMAL", "#3f3f3f");
    public static final Status WARNING = new Status(2, "WARNING", "#C47003");
    public static final Status FAILURE = new Status(3, "FAILURE", "#ed2c10");
    public static final Status ERROR = new Status(4, "ERROR", "#ed2c10");
    private static final Status[] ourAllInstances = new Status[]{UNKNOWN, NORMAL, WARNING, FAILURE, ERROR};
    private final byte myPriority;
    private final String myDebugName;
    private final String myHtmlColor;

    Status(int priority, String name, String htmlColor) {
        this.myPriority = (byte)priority;
        this.myDebugName = name;
        this.myHtmlColor = htmlColor;
    }

    public byte getPriority() {
        return this.myPriority;
    }

    public String getText() {
        return this.myDebugName.equals("NORMAL") ? "SUCCESS" : this.myDebugName;
    }

    public String getHtmlColor() {
        return this.myHtmlColor;
    }

    public boolean isSuccessful() {
        return this.getPriority() <= WARNING.getPriority() && this != UNKNOWN;
    }

    public boolean isFailed() {
        return this.getPriority() > WARNING.getPriority();
    }

    public boolean isIgnored() {
        return UNKNOWN.equals(this);
    }

    public static Status getStatus(int priority) {
        switch (priority) {
            case 1: {
                return NORMAL;
            }
            case 2: {
                return WARNING;
            }
            case 3: {
                return FAILURE;
            }
            case 4: {
                return ERROR;
            }
        }
        return UNKNOWN;
    }

    public static Status getStatus(String statusName) {
        for (int i = 0; i < ourAllInstances.length; ++i) {
            Status instance = ourAllInstances[i];
            if (!instance.myDebugName.equals(statusName) && !instance.getText().equals(statusName)) continue;
            return instance;
        }
        return null;
    }

    public static Status getWorstStatus(Status s1, Status s2) {
        return s1.above(s2) ? s1 : s2;
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean above(Status status) {
        return this.getPriority() > status.getPriority();
    }
}

