/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ValueResolver;
import jetbrains.buildServer.parameters.impl.ParametersResolverUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterBasedValueResolver
implements ValueResolver {
    @NotNull
    private final ParameterResolver myResolver;
    @NotNull
    private final ParametersProvider myDictionary;

    public ParameterBasedValueResolver(@NotNull ParameterResolver resolver, @NotNull ParametersProvider dictionary) {
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/ParameterBasedValueResolver.<init> must not be null");
        }
        if (dictionary == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/ParameterBasedValueResolver.<init> must not be null");
        }
        this.myResolver = resolver;
        this.myDictionary = dictionary;
    }

    @Override
    @NotNull
    public ProcessingResult resolve(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/ParameterBasedValueResolver.resolve must not be null");
        }
        ProcessingResult processingResult = ParametersResolverUtil.resolveSingleValue(value, this.myDictionary, this.myResolver);
        if (processingResult == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/ParameterBasedValueResolver.resolve must not return null");
        }
        return processingResult;
    }

    @Override
    @NotNull
    public Map<String, String> resolve(@NotNull Map<String, String> unresolved) {
        if (unresolved == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/ParameterBasedValueResolver.resolve must not be null");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        LinkedHashMap<String, String> toResolve = new LinkedHashMap<String, String>(unresolved);
        List<ProcessingResult> resolved = ParametersResolverUtil.resolveValues(new ArrayList<String>(toResolve.values()), this.myDictionary, this.myResolver);
        int idx = 0;
        for (String key : toResolve.keySet()) {
            result.put(key, resolved.get(idx++).getResult());
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/ParameterBasedValueResolver.resolve must not return null");
        }
        return hashMap;
    }
}

