/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.parameters.ContextVariables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HidingContextVariables
implements ContextVariables {
    @NotNull
    private final ContextVariables myProvider;
    @Nullable
    private Collection<String> myAllowedNames;

    public HidingContextVariables(@NotNull ContextVariables provider, @Nullable Collection<String> allowedNames) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/HidingContextVariables.<init> must not be null");
        }
        this.myProvider = provider;
        this.myAllowedNames = allowedNames;
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/HidingContextVariables.get must not be null");
        }
        if (this.myAllowedNames == null || this.myAllowedNames.contains(name)) {
            return this.myProvider.get(name);
        }
        return null;
    }

    @Override
    public int size() {
        if (this.myAllowedNames == null) {
            return this.myProvider.size();
        }
        return this.getAll().size();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, Object> getAll() {
        Map<String, Object> map;
        if (this.myAllowedNames == null) {
            map = this.myProvider.getAll();
            if (map == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/HidingContextVariables.getAll must not return null");
            return map;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        assert (this.myAllowedNames != null);
        for (String name : this.myAllowedNames) {
            Object value = this.myProvider.get(name);
            if (value == null) continue;
            result.put(name, value);
        }
        map = result;
        if (map != null) return map;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/HidingContextVariables.getAll must not return null");
    }

    public void setAllowedNames(@Nullable Collection<String> allowedNames) {
        this.myAllowedNames = allowedNames;
    }
}

