/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.parameters.MapParametersProvider;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.impl.MapParametersProviderImpl;
import jetbrains.buildServer.parameters.impl.ParametersInOut;
import jetbrains.buildServer.parameters.impl.ParametersInOutList;
import jetbrains.buildServer.parameters.impl.ParametersProviderFactory;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersResolverUtil {
    public static final String SINGLE_VALUE_KEY = "__single_reference_key_";

    public static ProcessingResult resolveSingleValue(@NotNull String value, @NotNull ParametersProvider resolutionParameters, @NotNull ParameterResolver processor) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersResolverUtil.resolveSingleValue must not be null");
        }
        if (resolutionParameters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersResolverUtil.resolveSingleValue must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersResolverUtil.resolveSingleValue must not be null");
        }
        return ParametersResolverUtil.resolveValues(Collections.singletonList(value), resolutionParameters, processor).get(0);
    }

    public static List<ProcessingResult> resolveValues(@NotNull List<String> values, @NotNull ParametersProvider resolutionParameters, @NotNull ParameterResolver processor) {
        if (values == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersResolverUtil.resolveValues must not be null");
        }
        if (resolutionParameters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersResolverUtil.resolveValues must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersResolverUtil.resolveValues must not be null");
        }
        ParametersInOutList parametersInOutList = new ParametersInOutList();
        ParametersProviderFactory parametersProviderFactory = new ParametersProviderFactory(){

            @NotNull
            public MapParametersProvider getParametersProvider() {
                MapParametersProviderImpl mapParametersProviderImpl = new MapParametersProviderImpl();
                if (mapParametersProviderImpl == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersResolverUtil$1.getParametersProvider must not return null");
                }
                return mapParametersProviderImpl;
            }
        };
        MapParametersProviderImpl unresolvedParameters = new MapParametersProviderImpl();
        for (int i = 0; i < values.size(); ++i) {
            unresolvedParameters.put(SINGLE_VALUE_KEY + i, values.get(i));
        }
        ParametersInOut dictionaryParameters = new ParametersInOut("dictionaryParameters", resolutionParameters, parametersProviderFactory);
        parametersInOutList.addParameters(dictionaryParameters);
        ParametersInOut valueParams = new ParametersInOut("valueDict", unresolvedParameters, parametersProviderFactory);
        parametersInOutList.addParameters(valueParams);
        parametersInOutList.resolveParameters(processor, "valueDict");
        ArrayList<ProcessingResult> res = new ArrayList<ProcessingResult>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            res.add(valueParams.createProcessingResult(SINGLE_VALUE_KEY + i, values.get(i)));
        }
        return res;
    }
}

