/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.configuration.ChangeListener;
import jetbrains.buildServer.configuration.FileWatcher;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamCityProperties {
    public static final String TEAMCITY_DATA_PATH_PROPERTY = "teamcity.data.path";
    public static final String TEAMCITY_DATA_PATH_ENV = "TEAMCITY_DATA_PATH";
    public static final String TEAMCITY_DEBUG_MODE = "teamcity.development.mode";
    public static final String BUILD_SERVER_HOME = TeamCityProperties.getDataPath();
    public static final String SYSTEM_HOME = BUILD_SERVER_HOME + "system";
    public static final String CONFIG_HOME = BUILD_SERVER_HOME + "config";
    private static volatile Map<String, String> ourProperties = new HashMap<String, String>();
    private static final AtomicBoolean myReadInProgress = new AtomicBoolean(false);
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final String PROPERTIES_FILE_NAME = "internal.properties";
    private static File ourPropertiesFile = new File(CONFIG_HOME, "internal.properties");
    private static FileWatcher ourFileWatcher = null;

    public static boolean getBoolean(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getBoolean must not be null");
        }
        String result = TeamCityProperties.getPropertyOrNull(key);
        return result != null ? Boolean.parseBoolean(result) : Boolean.getBoolean(key);
    }

    public static boolean getBooleanOrTrue(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getBooleanOrTrue must not be null");
        }
        String result = TeamCityProperties.getProperty(key, "true");
        return Boolean.parseBoolean(result);
    }

    public static int getInteger(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getInteger must not be null");
        }
        return TeamCityProperties.getInteger(key, 0);
    }

    public static int getInteger(@NotNull String key, int defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getInteger must not be null");
        }
        String result = TeamCityProperties.getPropertyOrNull(key);
        try {
            return result != null ? Integer.parseInt(result) : Integer.getInteger(key, defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float getFloat(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getFloat must not be null");
        }
        return TeamCityProperties.getFloat(key, 0.0f);
    }

    public static float getFloat(@NotNull String key, float defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getFloat must not be null");
        }
        String result = TeamCityProperties.getPropertyOrNull(key);
        try {
            return result != null ? Float.parseFloat(result) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getLong must not be null");
        }
        return TeamCityProperties.getLong(key, 0L);
    }

    public static long getLong(@NotNull String key, long defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getLong must not be null");
        }
        String result = TeamCityProperties.getPropertyOrNull(key);
        try {
            return result != null ? Long.parseLong(result) : Long.getLong(key, defaultValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not be null");
        }
        String string = TeamCityProperties.getProperty(key, "");
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not return null");
        }
        return string;
    }

    @Nullable
    public static String getPropertyOrNull(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getPropertyOrNull must not be null");
        }
        String result = TeamCityProperties.get(key);
        return result != null ? result : System.getProperty(key);
    }

    @Nullable
    public static String getPropertyOrNull(@NotNull String key, @Nullable String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getPropertyOrNull must not be null");
        }
        String result = TeamCityProperties.get(key);
        return result != null ? result : System.getProperty(key, defaultValue);
    }

    @NotNull
    public static String getProperty(@NotNull String key, @NotNull String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not be null");
        }
        String result = TeamCityProperties.get(key);
        String string = result != null ? result : System.getProperty(key, defaultValue);
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getProperty must not return null");
        }
        return string;
    }

    @NotNull
    public static String getDataPath() {
        String userHome = System.getProperty("user.home");
        String dataPath = userHome + "/.BuildServer";
        String theTeamCityDataPathPropertyValue = System.getProperty(TEAMCITY_DATA_PATH_PROPERTY);
        String theTeamCityDataPathEnvValue = System.getenv(TEAMCITY_DATA_PATH_ENV);
        if (theTeamCityDataPathPropertyValue != null) {
            dataPath = theTeamCityDataPathPropertyValue;
        } else if (theTeamCityDataPathEnvValue != null) {
            dataPath = theTeamCityDataPathEnvValue;
        }
        if (!dataPath.endsWith("/")) {
            dataPath = dataPath + "/";
        }
        String string = dataPath.replace(File.separatorChar, '/');
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getDataPath must not return null");
        }
        return string;
    }

    @NotNull
    public static Pair<Properties, Properties> getAllProperties() {
        Properties fileProperties = TeamCityProperties.readProperties();
        Properties javaProperties = new Properties();
        javaProperties.putAll((Map<?, ?>)System.getProperties());
        Pair pair = new Pair((Object)fileProperties, (Object)javaProperties);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getAllProperties must not return null");
        }
        return pair;
    }

    public static void startFileWatching() {
        if (ourFileWatcher != null) {
            ourFileWatcher.stop();
        }
        ourFileWatcher = new FileWatcher(ourPropertiesFile);
        ourFileWatcher.registerListener(new ChangeListener(){

            public void changeOccured(String requestor) {
                TeamCityProperties.readProperties();
            }
        });
        ourFileWatcher.setSleepingPeriod(TeamCityProperties.getCurrentSleepingInterval());
        ourFileWatcher.start();
    }

    public static void setPropertiesFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.setPropertiesFile must not be null");
        }
        File file = new File(path);
        if (!file.exists()) {
            System.err.println("The file \"" + path + "\" does not exist");
            return;
        }
        ourPropertiesFile = file;
        TeamCityProperties.readProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Properties readProperties() {
        Properties properties;
        block27: {
            Properties properties2;
            InputStream input;
            block29: {
                Properties properties3;
                block28: {
                    input = null;
                    try {
                        if (ourPropertiesFile == null || !ourPropertiesFile.exists()) break block27;
                        Properties properties4 = new Properties();
                        input = new FileInputStream(ourPropertiesFile);
                        properties4.load(input);
                        if (properties4.isEmpty()) {
                            if (ourPropertiesFile.length() == 0L) {
                                Properties properties5 = EMPTY_PROPERTIES;
                                properties3 = properties5;
                                break block28;
                            }
                            String text = "";
                            int attempt = 0;
                            while (text.isEmpty() && ++attempt < 3) {
                                text = FileUtil.readText(ourPropertiesFile);
                            }
                            properties4.load(new StringReader(text));
                        }
                        HashMap<String, String> map = new HashMap<String, String>();
                        for (Map.Entry<Object, Object> entry : properties4.entrySet()) {
                            map.put(entry.getKey().toString(), entry.getValue().toString());
                        }
                        ourProperties = map;
                        long interval = TeamCityProperties.getCurrentSleepingInterval();
                        if (ourFileWatcher != null && ourFileWatcher.getSleepingPeriod() != interval) {
                            ourFileWatcher.setSleepingPeriod(interval);
                        }
                        properties2 = properties4;
                        break block29;
                    }
                    catch (Exception e) {
                        System.err.println("Failed to read " + ourPropertiesFile + " file: " + e.getMessage());
                        break block27;
                    }
                }
                properties = properties3;
                if (properties3 == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.readProperties must not return null");
                return properties;
            }
            properties = properties2;
            if (properties == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.readProperties must not return null");
            return properties;
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((properties = EMPTY_PROPERTIES) != null) return properties;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.readProperties must not return null");
    }

    private static long getCurrentSleepingInterval() {
        long interval = TeamCityProperties.getLong("teamcity.internal.properties.reread.interval.ms", 10000L);
        return interval < 0L ? 10000L : interval;
    }

    @Nullable
    private static String get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/serverSide/TeamCityProperties.get must not be null");
        }
        return ourProperties.get(key);
    }

    @NotNull
    static FileWatcher getFileWatcher() {
        FileWatcher fileWatcher = ourFileWatcher;
        if (fileWatcher == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/serverSide/TeamCityProperties.getFileWatcher must not return null");
        }
        return fileWatcher;
    }

    static {
        TeamCityProperties.readProperties();
    }
}

